//...................................

// Copyright  2000 - 2005 by TAN$TAAFL Software Company
//						      14 Foster St., Banician
//                            Olongapo City 2200
//                            Philippines

// This source code is NOT IN THE PUBLIC DOMAIN and is NOT OPEN SOURCE.
// It is provided solely for the purpose of letting you determine how
// the program works, and that there are no backdoors or hidden code
// in the program. Anyone that wants to use any portion of this code
// in their own program please contact the author at:

//							  MacGregor K. Phillips
//                            PSC 517 Box RS
//                            FPO AP 96517-1000

// Procedures for chat and setting time from the internet.
//........................................................
#include <WinSock2.h>
#include <windows.h>  
#include "Tsc.h"
#include "ContextHelp.h"
#include "Prototypes.h"
#include <Shlwapi.h>
#include <Commctrl.h>
#include <htmlhelp.h>
#include <shellapi.h>
#include <shlobj.h>
#include <Ras.h>
#include <Raserror.h>
#include <Wininet.h>
#include "Tscmsg.h"
#include <richedit.h>
//#include <ssce.h>
#define STRSAFE_LIB
#include <strsafe.h>

// Default string safe flags.
//...........................
DWORD	dwStringSafeFlag = STRSAFE_FILL_BEHIND_NULL | STRSAFE_IGNORE_NULLS | STRSAFE_NULL_ON_FAILURE;

extern	HINSTANCE			hInst;
extern	LPCTSTR				lpszAppName;
extern	LPCTSTR				lpszNullString;
extern	LPTSTR				lpszNA;
extern	LPCTSTR				lpIconPointer;
extern	BOOL				bProcessInProgress;
extern	HWND				hMainWindow;
extern	BOOL				bIsWinNT;
extern	DWORD				dwTip;
extern	DWORD				dwTipString;
extern	BOOL				bLoggedOn;
extern	LHANDLE				lHandle;
extern	TCHAR				szFileToEncipher[MAX_PATH];
extern	BOOL				bHaveMAPI;
extern	HANDLE				hDlgCurrent;
extern	LPBYTE				lpEncSecKey;
extern	LPSECRETKEYDATA		lpMyKey;
extern	DWORD				dwPageCount;
extern  LPBYTE				lpOutBuffer;
extern	LPTSTR				lpszRTF;
extern	BYTE				rphdr[MAX_REPRO_LGTH];
extern	BOOL				bCancelOperation;
extern	BOOL				bWin2000OrGreater;
extern	BOOL				bFromChat;
extern	COLORREF			crOleBkg;
extern	HWND				hCurrentRtfWnd;
extern	DWORD				dwUseSessionKey;
extern	BYTE				RingMask;
extern	TCHAR				szOtpKeyFile[MAX_PATH];
extern	BOOL				bUseSentrySpellChecker;
extern	HCURSOR				hCursorArrow;

// Externs for keys.
//..................
extern	BYTE				Temp1;
extern	BYTE				Temp9[MAX_MOD_SLOP];
extern	BYTE				Temp6[MAX_MOD_SLOP*2];
extern	DWORD				dwCountBytes;
extern	DWORD				dwCountBits;
extern	DWORD				dwReproLength;
extern	LPBYTE				lpCsumOffset;
extern	LPBYTE				lpSeedOffset;
extern	DWORD				dwRngsUsed;
extern	BYTE				RingMask;
extern	DWORD				Seed;
extern	DWORD				TopsArray[256];
extern	DWORD				FactorArray[256];
extern	DWORD				SeedsArray[256];
extern	BYTE				LastSeed;
extern	DWORD				DbleNumber;
extern	DWORD				Divisor1;
extern	BYTE				TempUserId[256];
extern	HANDLE				hIdxHandle2;
extern	LPBYTE				lpIndexFile2;
extern	SEARCH_TEMPLATE		KeyIdSearch;
extern	LPBYTE				lpKeyBuffer2;
extern	LPBYTE				lpKeyBufferDup2;
extern	DWORD				dwIdxOffset2;
extern	BOOL				bWipeOTPFileAfterUse;
extern	BOOL				bWipeTrueOTPFileAfterUse;
extern	CONFIG				cfg;
extern	TCHAR				szMyRichEditCtrl[16];
extern	BOOL				bHaveRichEdit41orGreater;

#define WM_SOCKET_NOTIFY	(WM_USER + 1)
#define CHAT_PORT			5555

// Variable for setting the time from the internet.
//.................................................
TCHAR				szServer1[] = "129.6.15.28";
TCHAR				szServer2[] = "129.6.15.29";
TCHAR				szServer3[] = "132.163.4.101";
TCHAR				szServer4[] = "132.163.4.102";
TCHAR				szServer5[] = "132.163.4.103";
TCHAR				szServer6[] = "128.138.140.44";
TCHAR				szServer7[] = "192.43.244.18";
TCHAR				szServer8[] = "131.107.1.10";
TCHAR				szServer9[] = "216.200.93.8";

LPBYTE				lpServers[] = {(LPBYTE)&szServer1,(LPBYTE)&szServer2,
								   (LPBYTE)&szServer3,(LPBYTE)&szServer4,
								   (LPBYTE)&szServer5,(LPBYTE)&szServer6,
								   (LPBYTE)&szServer7,(LPBYTE)&szServer8,
								   (LPBYTE)&szServer9};

// Socket variables.
//..................
HWND				hWndEdit;
HWND				hChat1, hChat2, hChat3;
HWND				hButton;
DWORD				dwConnection;
TCHAR				szIPAddress[RAS_MaxIpAddress + 1];
TCHAR				szClientIP[RAS_MaxIpAddress + 1];
TCHAR				szNickName[48];
LPBYTE				lpIPAddress;
BOOL				bIPAddress;
DWORD				dwConnection;
BOOL				bMyTimerSet;
BOOL				bSettingTime;
HANDLE				hChatEvent;
HANDLE				hChatOpen;
HANDLE				hChatSession;
BOOL				bWeDialedInternet = FALSE;
SOCKET				sock;
struct sockaddr_in	sa;
struct sockaddr_in	saClient;
struct sockaddr_in	saTemp;
int					iMaxMsgSize;
int					iChatMsgLength;
EDITSTREAM			eStreamSend;
EDITSTREAM			eStreamRecv;
BOOL				bProcessingMsg;
BOOL				bSendingMsg;
BOOL				bMessageBeingTyped;
DWORD				dwMessageNumber;
BOOL				bSendEndMsg;
HWND				hCtrlWin;
DWORD				dwMaxClientData;
BOOL				bStartup;
BOOL				bWaitOnProcessing;
BOOL				bWaitOnSend;

// Variables for the new thread procedures.
//.........................................
WSADATA				wsa_data;
BOOL				bBusy;
BOOL				bOnline;
BOOL				bReceiveActive;
DWORD				dwCallStatus;
BOOL				bIamTheSlave;
BOOL				bHaveClientKey;
DWORD				dwSendStatus;
DWORD				dwChatRetry;
int					iTimeServer = -1;

// Receive thread.
//................
HANDLE				hReceiveThread;
DWORD				dwReceiveThreadID;
HANDLE				hConnectThread;
DWORD				dwConnectThreadID;
HANDLE				hSendThread;
DWORD				dwSendThreadID;

// Chat variables.
//................
LPCTSTR				lpChat640 = "CHAT640";
LPCTSTR				lpChat800 = "CHAT800";
LPCTSTR				lpChat1024 = "CHAT1024";

LPCTSTR				lpChat640New = "CHAT640NEW";
LPCTSTR				lpChat800New = "CHAT800NEW";
LPCTSTR				lpChat1024New = "CHAT1024NEW";

BOOL				bFromChat = FALSE;
BOOL				bNeedChatKey = FALSE;
BOOL				bChatKeySet = TRUE;
BOOL				bSendFocus = FALSE;
BOOL				bMathInProgress;

// Send and receive chat message pointers.
//........................................
LPDATAMSG			lpSend;
LPDATAMSG			lpReceive;
LPDATAMSG			lpPrevious;

MSGHDR				mhTyping;
MSGHDR				mhEndChat;

// Client Mod n and e variables.
//..............................
CLIENTKEY			MyKey;
CLIENTKEY			ck;

// Wipe parameters for True One Time Pad File.
//............................................
ULARGE_INTEGER		uliMyStartPosition;
ULARGE_INTEGER		uliMyWipeLength;
ULARGE_INTEGER		uliCkStartPosition;
ULARGE_INTEGER		uliCkWipeLength;
ULARGE_INTEGER		uliMyStartPoint;
ULARGE_INTEGER		uliCkStartPoint;
BOOL				bNoSendClr = TRUE;

CHOOSECOLOR			crChatBkg;
CHOOSECOLOR			crChatText;

//SSCE_U32			MarkOptions = SSCE_BACKGROUND_MARK_COLOR | SSCE_BACKGROUND_CHECK_ALL |
//								  SSCE_BACKGROUND_CONTEXT_MENU;
//SSCE_U32			MarkColor = 0x0000ff;

TCHAR	szChatSaveAs[] = "File Name: %s\n\nYour Chat Session was successfully saved to disk.";

BYTE	szSearchSmiley[] = "::)";
LONG	lCharPos;

// 2-way encrypted chat.
//......................
VOID Chat()
{
	int				i;
	DWORD			dwOldHelpTopic;
	LPCTSTR			lpDialogBox;
	HANDLE			hRtf = 0;
	BOOL			bError, bResult;
	DWORD			dwTimeOut;
	DWORD			dwExitCode;

	dwOldHelpTopic = ChangeHelpTopic(IDH_CHAT);
	bSendFocus = TRUE;
	bProcessInProgress = TRUE;
	hChatSession = 0;
	bBusy = FALSE;

	ZeroMemory(&MyKey,sizeof(CLIENTKEY));
	ZeroMemory(&ck,sizeof(CLIENTKEY));

	if (cfg.cp.iServer)
	{
		if (iTimeServer == -1)
		{
			iTimeServer = cfg.cp.iServer - IDC_SERVER1;
		}
	}
	else
	{
		iTimeServer = 0;
	}
	lpMyKey = AllocateMemory(sizeof(SECRETKEYDATA));
	if (!lpMyKey)
	{
		goto ChatEnd;
	}
	// Setup the secret key components and then hide them.
	//....................................................
	bError = SetupDiaryKey((LPBYTE)&cfg.cp.ChatKey);
	if (bError)
	{
		goto ChatEnd;
	}
	// Set up the Mod n and e to send to the client.
	//..............................................
	MyKey.dwN_Bytes = lpMyKey->dwN_Bytes;
	MyKey.dwN_Bits = lpMyKey->dwN_Bits;
	CopyMemory(&MyKey.Modn,lpMyKey->Modulus_N,MAX_MOD_SLOP);
	CopyMemory(&MyKey.E_Temp,lpMyKey->E_Temp,MAX_MOD_SLOP);
	CopyMemory(&MyKey.ChatKeyID,&cfg.cp.ChatKey,8);

	bResult = EncComponents();
	if (!bResult)
	{
		goto ChatEnd;
	}
	// Load the rich text edit dll.
	//.............................
	hRtf = LoadLibrary((LPCTSTR)&szMyRichEditCtrl);
	if (!hRtf)
	{
		ErrorProcedure((LPTSTR)&szMyRichEditCtrl,IDS_LOADLIBRARY,MB_OK);
		goto ChatEnd;
	}
	// Determine the current display resolution.
	//..........................................
	i = GetSystemMetrics(SM_CXFULLSCREEN);

	// Allocate memory for the send and receive buffers.
	//..................................................
	lpSend = AllocateMemory(sizeof(DATAMSG));
	lpReceive = AllocateMemory(sizeof(DATAMSG));
	lpPrevious = AllocateMemory(sizeof(DATAMSG));
	if (!lpSend || !lpReceive || !lpPrevious)
	{
		goto ChatEnd;
	}
	lpSend->hdr.signature = CHAT_SIGNATURE;

	// Create an event for the chat procedure.
	//........................................
	hChatEvent = CreateEvent(NULL,TRUE,FALSE,TEXT("ChatEvent"));
	if (!hChatEvent)
	{
		ErrorProcedure(TEXT("ChatEvent"),IDS_CREATEEVENT,MB_OK);
		goto ChatEnd;
	}
	// Display the dialog box to read a message with depending
	// on the current screen resolution.
	//...............................................
	if (bHaveRichEdit41orGreater)
	{
		if (i >= 950)
		{
			lpDialogBox = lpChat1024New;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpChat800New;
		}
		else
		{
			lpDialogBox = lpChat640New;
		}
	}
	else
	{
		if (i >= 950)
		{
			lpDialogBox = lpChat1024;
		}
		else if (i >= 750)
		{
			lpDialogBox = lpChat800;
		}
		else
		{
			lpDialogBox = lpChat640;
		}
	}
	hChatSession = CreateDialog(hInst,lpDialogBox,hMainWindow,(DLGPROC)ChatProc);
	if (hChatSession == NULL)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
		goto ChatEnd;
	}
	EmptyTheMessageQue();

	// Open our event and wait.
	//.........................
	hChatOpen = OpenEvent(SYNCHRONIZE,FALSE,TEXT("ChatEvent"));
	if (!hChatOpen)
	{
		DestroyWindow(hChatSession);
		goto ChatEnd;
	}
	// We have to wait for the Edit Event to become signaled before
	// we can return and quit.
	//.............................................................
	while(TRUE)
	{
		if (WaitForSingleObject(hChatEvent,0) == WAIT_OBJECT_0)
		{
			break;
		}
		EmptyTheMessageQue();
	}
	EmptyTheMessageQue();

	ChatEnd:

	ZeroMemory(&szIPAddress,sizeof(szIPAddress));
	ZeroMemory(&szClientIP,sizeof(szClientIP));
	ZeroMemory(&ck,sizeof(CLIENTKEY));
	ZeroMemory(&MyKey,sizeof(CLIENTKEY));
	lpIPAddress = 0;
	bIPAddress = FALSE;

	// Close the connect thread.
	//..........................
	if (hConnectThread)
	{
		dwTimeOut = GetTickCount() + 2000;

		while(TRUE)
		{
			if (GetTickCount() >= dwTimeOut)
			{
				break;
			}
			bResult = GetExitCodeThread(hConnectThread,&dwExitCode);
			if (!bResult)
			{
				ErrorProcedure(TEXT("Connect Thread"),IDS_GETEXITCODETHRD,MB_OK);
				break;
			}
			if (dwExitCode != STILL_ACTIVE)
			{
				CloseHandle(hConnectThread);
				hConnectThread = 0;
				break;
			}
			Sleep(10);
		}
	}
	// Close the send thread.
	//.......................
	if (hSendThread)
	{
		dwTimeOut = GetTickCount() + 2000;

		while(TRUE)
		{
			if (GetTickCount() >= dwTimeOut)
			{
				break;
			}
			bResult = GetExitCodeThread(hSendThread,&dwExitCode);
			if (!bResult)
			{
				ErrorProcedure(TEXT("Send Thread"),IDS_GETEXITCODETHRD,MB_OK);
				break;
			}
			if (dwExitCode != STILL_ACTIVE)
			{
				CloseHandle(hSendThread);
				hSendThread = 0;
				break;
			}
			Sleep(10);
		}
	}
	// Close our socket and threads.
	//..............................
	if (bReceiveActive == TRUE)
	{
		if (sock)
		{
			closesocket(sock);
			sock = 0;
		}
		while(bReceiveActive == TRUE)
		{
			Sleep(10);
		}
		dwTimeOut = GetTickCount() + 2000;

		while(TRUE)
		{
			if (GetTickCount() >= dwTimeOut)
			{
				break;
			}
			bResult = GetExitCodeThread(hReceiveThread,&dwExitCode);
			if (!bResult)
			{	
				ErrorProcedure(TEXT("Receive Thread"),IDS_GETEXITCODETHRD,MB_OK);
				break;
			}
			if (dwExitCode != STILL_ACTIVE)
			{
				CloseHandle(hReceiveThread);
				hReceiveThread = 0;
				break;
			}
			Sleep(10);
		}
	}
	// Hangup asks if you want to disconnect.
	//.......................................
	HangUp(hMainWindow);

	if (bStartup)
	{
		WSACleanup();
		bStartup = FALSE;
	}
	if (lpMyKey)
	{
		ZeroMemory(lpMyKey,sizeof(LPSECRETKEYDATA));
		DeallocateMemory(lpMyKey);
	}
	if (lpEncSecKey)
	{
		DeallocateMemory(lpEncSecKey);
		lpEncSecKey = 0;
	}
	if (hChatOpen)
	{
		CloseHandle(hChatOpen);
		hChatOpen = 0;
	}
	if (hChatEvent)
	{
		CloseHandle(hChatEvent);
		hChatEvent = 0;
	}
	if (hRtf)
	{
		FreeLibrary(hRtf);
	}
	if (lpSend)
	{
		ZeroMemory(lpSend,sizeof(DATAMSG));
		DeallocateMemory(lpSend);
		lpSend = 0;
	}
	if (lpReceive)
	{
		ZeroMemory(lpReceive,sizeof(DATAMSG));
		DeallocateMemory(lpReceive);
		lpReceive = 0;
	}
	if (lpPrevious)
	{
		ZeroMemory(lpPrevious,sizeof(DATAMSG));
		DeallocateMemory(lpPrevious);
		lpPrevious = 0;
	}
	hChat1 = 0;
	hChat2 = 0;
	hChat3 = 0;

	bSendFocus = FALSE;
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for encrypted chat.
//.......................................
LRESULT CALLBACK ChatProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	BOOL			bErr;
	int				iResult;
	int				iIPA, iNickName;
	DWORD			dwExitCode;
	LONG			cb;
	LONG			cLines;
	BOOL			bResult;
	DWORD			dwTimeOut;
	CHARRANGE		cr;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			hChat1 = GetDlgItem(hDlg,IDC_CHAT1);
			hChat2 = GetDlgItem(hDlg,IDC_CHAT2);
			hChat3 = GetDlgItem(hDlg,IDC_CHAT3);

			hConnectThread = 0;
			hReceiveThread = 0;
			hSendThread = 0;
			dwCallStatus = CHAT_PENDING;
			bIamTheSlave = TRUE;
			bHaveClientKey = FALSE;
			bProcessingMsg = FALSE;
			bSendingMsg = FALSE;
			bMessageBeingTyped = FALSE;
			dwMessageNumber = 0;
			bSendEndMsg = FALSE;
			hCtrlWin = 0;
			bReceiveActive = FALSE;
			bStartup = FALSE;
			bWaitOnProcessing = FALSE;
			bWaitOnSend = FALSE;
			lCharPos = 0;
			hCurrentRtfWnd = hChat1;

			// Setup our message being typed short message.
			//.............................................
			mhTyping.ack = 0;
			mhTyping.command = CHAT_TYPING_MSG;
			mhTyping.length = 0;
			mhTyping.signature = CHAT_SIGNATURE;

			mhEndChat.ack = 0;
			mhEndChat.command = CHAT_END;
			mhEndChat.length = 0;
			mhEndChat.signature = CHAT_SIGNATURE;

			// Set the text limit for each rtf control.
			//.........................................
			SendDlgItemMessage(hDlg,IDC_CHAT1,EM_EXLIMITTEXT,0,(5120 * 1024));
			SendDlgItemMessage(hDlg,IDC_CHAT2,EM_EXLIMITTEXT,0,(128 * 1024));
			SendDlgItemMessage(hDlg,IDC_CHAT3,EM_EXLIMITTEXT,0,(5120 * 1024));

			SendDlgItemMessage(hDlg,IDC_ISP,EM_SETLIMITTEXT,(WPARAM) 32,0);
			SendDlgItemMessage(hDlg,IDC_NICKNAME,EM_SETLIMITTEXT,(WPARAM) 32,0);

			// Setup the rich text edit control.
			//..................................
			SendDlgItemMessage(hDlg,IDC_CHAT1,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_CHAT1,EM_SETEVENTMASK,0,ENM_LINK);

			SendDlgItemMessage(hDlg,IDC_CHAT2,EM_AUTOURLDETECT,(WPARAM)TRUE,0);
			SendDlgItemMessage(hDlg,IDC_CHAT2,EM_SETEVENTMASK,0,ENM_KEYEVENTS | ENM_LINK);

			SetDlgItemText(hDlg,IDC_NICKNAME,(LPCTSTR)&cfg.cp.szNickName);

			// Setup ole callback.
			//....................
			SetupOleCallback(hDlg,IDC_CHAT1);

			// Set up the character formating and background colors.
			//......................................................
			if (!cfg.cp.cfSend.cbSize)
			{
				cfg.cp.cfSend.cbSize = sizeof(CHARFORMAT2);
				SendDlgItemMessage(hDlg,IDC_CHAT1,EM_GETCHARFORMAT,0,(LPARAM)&cfg.cp.cfSend);
				cfg.cp.crChat1 = GetSysColor(COLOR_WINDOW);
				cfg.cp.crChat2 = cfg.cp.crChat1;
				cfg.cp.crChat3 = cfg.cp.crChat1;
			}
			else
			{
				SendDlgItemMessage(hDlg,IDC_CHAT1,EM_SETBKGNDCOLOR,0,
								  (LPARAM)(COLORREF)cfg.cp.crChat1);
				SendDlgItemMessage(hDlg,IDC_CHAT2,EM_SETBKGNDCOLOR,0,
								  (LPARAM)(COLORREF)cfg.cp.crChat2);
				SendDlgItemMessage(hDlg,IDC_CHAT3,EM_SETBKGNDCOLOR,0,
								  (LPARAM)(COLORREF)cfg.cp.crChat3);
				bNoSendClr = FALSE;
			}
			// Set the background color for the smileys.
			//..........................................
			crOleBkg = cfg.cp.crChat1;

			CopyMemory(&cfg.cp.cfReceive,&cfg.cp.cfSend,sizeof(CHARFORMAT2));
			cfg.cp.cfReceive.dwMask |= CFM_BOLD;
			cfg.cp.cfReceive.dwEffects |= CFE_BOLD;
			cfg.cp.cfReceive.crTextColor = 0;
			SendDlgItemMessage(hDlg,IDC_CHAT1,EM_SETCHARFORMAT,SCF_ALL,
						      (LPARAM)&cfg.cp.cfReceive);
			SendDlgItemMessage(hDlg,IDC_CHAT2,EM_SETCHARFORMAT,SCF_ALL,
							  (LPARAM)&cfg.cp.cfSend);
			SendDlgItemMessage(hDlg,IDC_CHAT3,EM_SETCHARFORMAT,SCF_ALL,
							  (LPARAM)&cfg.cp.cfSend);

			// Turn off the text color buttons if we have not set a font yet.
			//...............................................................
			if (bNoSendClr)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_SENDTXTCLR),FALSE);
			}
			// Check to see if we are online or not. If we are, display our IP address
			// and setup the various command buttons.
			//........................................................................
			if (cfg.dwDialupNetwork)
			{
				// We are using dial-up networking to connect.
				//............................................
				bOnline = WeAreOnline2();
			}
			else
			{
				// We are not using dial-up networking to connect.
				//................................................
				bOnline = WeAreOnline(TRUE);
				EnableWindow(GetDlgItem(hDlg,IDC_DIAL),FALSE);
			}
			if (bOnline)
			{
				// Display our IP address. 
				//........................
				SetDlgItemText(hDlg,IDC_ISP,(LPCTSTR)&szIPAddress);

				// Create the socket to listen on.
				//................................
				bErr = InitializeSocket(hChat3);
				if (bErr)
				{
					DestroyWindow(hDlg);
				}
				// Set up the command buttons like we want them.
				//..............................................
				if (bHaveMAPI)
				{
					EnableWindow(GetDlgItem(hDlg,IDC_NOTIFY),TRUE);
				}
				EnableWindow(GetDlgItem(hDlg,IDC_DIAL),FALSE);
				EnableWindow(GetDlgItem(hDlg,IDC_CONNECT),TRUE);

				// Setup our timer to check to see if we are still online.
				//........................................................
				SetTimer(hDlg,MY_TIMER,60000,NULL);
			}
			else
			{
				if (!cfg.dwDialupNetwork)
				{
					EditPrintf(hChat3,TEXT("Your connection to the Internet is not functioning.\r\nPlease check your connection.\r\n\r\n"));
				}
			}
			// If we did not initialize the spell checker, gray its button.
			//.............................................................
			if (!bUseSentrySpellChecker)
			{
				EnableWindow(GetDlgItem(hDlg,IDC_CHAT_SPELL),FALSE);
			}
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			SetFocus(hChat2);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(FALSE);
		}

		case WM_NOTIFY:
		{
			LPENLINK		pEnlink;
			LPNMHDR			lpNmhdr;
			LPBYTE			lpLink;
			DWORD			dwLinkSize;
			CHARRANGE		range;
			LPMSGFILTER		lpMsgFilter;

			pEnlink = (LPENLINK)lParam;
			lpNmhdr = (LPNMHDR)lParam;
			lpMsgFilter = (LPMSGFILTER)lParam;

			switch(lpNmhdr->code) 
			{
				case EN_MSGFILTER:
				{
					if (lpNmhdr->idFrom == IDC_CHAT2 && bBusy)
					{
						if (lpMsgFilter->msg == WM_KEYDOWN)
						{
							if (lpMsgFilter->wParam == VK_RETURN)
							{
								if (IsWindowEnabled(GetDlgItem(hDlg,IDC_SEND)))
								{
									SendMessage(hChatSession,WM_COMMAND,IDC_SEND,0);
								}
								return(0);
							}
							if (lpMsgFilter->wParam == VK_F7)
							{
								if (!IsWindowEnabled(GetDlgItem(hDlg,IDC_SEND)))
								{
									EnableWindow(GetDlgItem(hDlg,IDC_SEND),TRUE);
								}
							}
							if (!bMessageBeingTyped)
							{
								// Send our message that we are typing a message.
								//...............................................
								SendTypeMsg(&saClient,&mhTyping,sizeof(MSGHDR));
								bMessageBeingTyped = TRUE;
							}
						}
						else if (lpMsgFilter->msg == WM_KEYUP)
						{
							if (lpMsgFilter->wParam == VK_RETURN)
							{
								return(0);
							}
						}
					}
				}
				break;

				case EN_LINK:
				{
					if (pEnlink->msg == WM_LBUTTONUP)
					{
						// Get the range and allocate the buffer.
						//.......................................
						dwLinkSize = pEnlink->chrg.cpMax - pEnlink->chrg.cpMin;
						if (dwLinkSize)
						{
							lpLink = AllocateMemory(dwLinkSize + 10);
							if (lpLink)
							{
								SetCursor(hCursorArrow);
								range.cpMax = pEnlink->chrg.cpMax;
								range.cpMin = pEnlink->chrg.cpMin;

								SendDlgItemMessage(hDlg,lpNmhdr->idFrom,EM_EXSETSEL,0,
												  (LPARAM)(CHARRANGE FAR *)&range);
								SendDlgItemMessage(hDlg,lpNmhdr->idFrom,EM_GETSELTEXT,0,
												  (LPARAM)lpLink);
								ShellExecute(NULL,"open",(LPCTSTR)lpLink,NULL,NULL,
											 SW_SHOWNORMAL);
								range.cpMin = -1;
								SendDlgItemMessage(hDlg,lpNmhdr->idFrom,EM_EXSETSEL,0,
												  (LPARAM)(CHARRANGE FAR *)&range);
								DeallocateMemory(lpLink);
							}
						}
					}
				}
				break;
			}
		}
		break;

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_DIAL:
				{	
					ZeroMemory(&cfg.cp.szNickName,sizeof(cfg.cp.szNickName));
					GetDlgItemText(hDlg,IDC_NICKNAME,(LPTSTR)&cfg.cp.szNickName,
								   sizeof(cfg.cp.szNickName));

					// We need a nickname before we can proceed.
					//..........................................
					if (lstrlen((LPCTSTR)&cfg.cp.szNickName) == 0)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NICKNAME_REQ,
									   MB_OK | MB_ICONINFORMATION | MB_HELP,
									   MB_ICONINFORMATION,0);
						break;
					}
					// Display our tip.
					//.................
					if (cfg.dwTips & CHAT_TIP)
					{
						dwTip = CHAT_TIP;
						dwTipString = IDS_CHAT_TIP;

						iResult = DialogBox(hInst,TEXT("TSCGTIP"),hMainWindow,
										   (DLGPROC)TscgTipProc);

						EmptyTheMessageQue();

						// See if we had a system error in creating the dialog box.
						//.........................................................
						if (iResult == -1)
						{
							ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
							break;
						}
					}
					// Dial the internet.
					//...................
	  				bErr = DialInternet(hDlg);
					if (bErr)
					{
						SetFocus(hChat2);
						break;
					}
					EmptyTheMessageQue();

					// If we cancelled out we cannot continue.
					//........................................
					if (szIPAddress[0] == 0)
					{
						break;
					}
					// Display our IP address.
					//........................
					SetDlgItemText(hDlg,IDC_ISP,(LPCTSTR)&szIPAddress);

					// Create the socket to listen on.
					//................................
					bErr = InitializeSocket(hChat3);
					if (bErr)
					{
						break;
					}
					// Set up the command buttons like we want them.
					//..............................................
					if (bHaveMAPI)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_NOTIFY),TRUE);
					}
					EnableWindow(GetDlgItem(hDlg,IDC_DIAL),FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_CONNECT),TRUE);
					SetFocus(hChat2);

					bOnline = TRUE;

					// Setup our timer to check to see if we are still online.
					//........................................................
					SetTimer(hDlg,MY_TIMER,6000,NULL);
				}
				break;

				case IDC_ENDCHAT:
				{	
					if (bSendEndMsg)
					{
						SendMyMsg(&saClient,&mhEndChat,sizeof(MSGHDR));
					}
					Sleep(2000);

					// Close the connect thread.
					//..........................
					if (hConnectThread)
					{
						EditPrintf(hChat3,TEXT("Shutting Down Connect Thread...\r\n"));
						dwTimeOut = GetTickCount() + 2000;

						while(TRUE)
						{
							if (GetTickCount() >= dwTimeOut)
							{
								EditPrintf(hChat3,TEXT("Close Connect Thread Timed Out."));
								Sleep(2000);
								break;
							}
							bResult = GetExitCodeThread(hConnectThread,&dwExitCode);
							if (!bResult)
							{
								ErrorProcedure(TEXT("Connect Thread"),IDS_GETEXITCODETHRD,
											   MB_OK);
								break;
							}
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hConnectThread);
								hConnectThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					// Close the send thread.
					//.......................
					if (hSendThread)
					{
						EditPrintf(hChat3,TEXT("Shutting Down Send Thread...\r\n"));
						dwTimeOut = GetTickCount() + 2000;

						while(TRUE)
						{
							if (GetTickCount() >= dwTimeOut)
							{
								EditPrintf(hChat3,TEXT("Close Send Thread Timed Out."));
								Sleep(2000);
								break;
							}
							bResult = GetExitCodeThread(hSendThread,&dwExitCode);
							if (!bResult)
							{
								ErrorProcedure(TEXT("Send Thread"),IDS_GETEXITCODETHRD,MB_OK);
								break;
							}
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hSendThread);
								hSendThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					// Check to see if we are still online.
					//.....................................
					if (cfg.dwDialupNetwork)
					{
						// We are using dial-up networking to connect.
						//............................................
						bOnline = WeAreOnline2();
					}
					else
					{
						// We are not using dial-up networking to connect.
						//................................................
						bOnline = WeAreOnline(FALSE);
						EnableWindow(GetDlgItem(hDlg,IDC_DIAL),FALSE);
					}
					if (bOnline)
					{
						// Reset the command buttons.
						//...........................	
						EnableWindow(GetDlgItem(hChatSession,IDC_CONNECT),TRUE);
						if (bHaveMAPI)
						{
							EnableWindow(GetDlgItem(hChatSession,IDC_NOTIFY),TRUE);
						}
						if (bSendEndMsg)
						{
							EditPrintf(hChat3,TEXT("Chat session ended.\r\nListening for incoming connections...\r\n\r\n"));
						}
						else
						{
							EditPrintf(hChat3,TEXT("Continuing to listen for incoming connections...\r\n\r\n"));
						}
					}
					else
					{
						// We are not online. Setup so we can start at the beginning.
						// Close the socket and threads.
						//...........................................................
						if (bReceiveActive == TRUE)
						{
							EditPrintf(hChat3,TEXT("Shutting Down Receive Thread...\r\n"));
							if (sock)
							{
								closesocket(sock);
								sock = 0;
							}
							while(bReceiveActive == TRUE)
							{
								Sleep(10);
							}
							dwTimeOut = GetTickCount() + 2000;

							while(TRUE)
							{
								if (GetTickCount() >= dwTimeOut)
								{
									EditPrintf(hChat3,TEXT("Close Receive Thread Timed Out."));
									Sleep(2000);
									break;
								}
								bResult = GetExitCodeThread(hReceiveThread,&dwExitCode);
								if (!bResult)
								{	
									ErrorProcedure(TEXT("Receive Thread"),IDS_GETEXITCODETHRD,
												   MB_OK);
									break;
								}
								if (dwExitCode != STILL_ACTIVE)
								{
									CloseHandle(hReceiveThread);
									hReceiveThread = 0;
									break;
								}
								Sleep(10);
							}
						}
						if (cfg.dwDialupNetwork)
						{
							EnableWindow(GetDlgItem(hDlg,IDC_DIAL),TRUE);
						}
						if (bHaveMAPI)
						{
							EnableWindow(GetDlgItem(hChatSession,IDC_NOTIFY),FALSE);
						}
						EnableWindow(GetDlgItem(hChatSession,IDC_CONNECT),FALSE);
						ZeroMemory(&szIPAddress,sizeof(szIPAddress));
						ZeroMemory(&szClientIP,sizeof(szClientIP));
						SetDlgItemText(hDlg,IDC_ISP,lpszNullString);
						SetDlgItemText(hDlg,IDC_CLIENTISP,lpszNullString);
						lpIPAddress = 0;
						bIPAddress = FALSE;
						bWeDialedInternet = FALSE;
						EditPrintf(hChat3,TEXT("Chat session ended.\r\nYou are no longer connected to the Internet.\r\n\r\n"));
						if (bStartup)
						{
							WSACleanup();
							bStartup = FALSE;
						}
					}
					EnableWindow(GetDlgItem(hChatSession,IDC_SEND),FALSE);
					EnableWindow(GetDlgItem(hChatSession,IDC_ENDCHAT),FALSE);
					SetFocus(hChat2);
					bBusy = FALSE;
					bIamTheSlave = TRUE;
					dwCallStatus = CHAT_PENDING;
					bProcessingMsg = FALSE;
					bSendingMsg = FALSE;
					bMessageBeingTyped = FALSE;
					dwMessageNumber = 0;
					bSendEndMsg = FALSE;
					bHaveClientKey = FALSE;
					bWaitOnProcessing = FALSE;
					bWaitOnSend = FALSE;
					ClearMsg();
				}
				break;

				case IDC_CONNECT:
				{
					// If we did not make a good connection on the first try
					// shut down the thread and try again. This will only
					// happend if we did not get an acknowledgement on a
					// connection request.
					//......................................................
					if (hConnectThread)
					{
						while(TRUE)
						{
							GetExitCodeThread(hConnectThread,&dwExitCode);
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hConnectThread);
								hConnectThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					ZeroMemory(&cfg.cp.szNickName,sizeof(cfg.cp.szNickName));
					ZeroMemory(&szClientIP,sizeof(szClientIP));

					iIPA = GetDlgItemText(hDlg,IDC_CLIENTISP,(LPTSTR)&szClientIP,
						                  sizeof(szClientIP));
					iNickName = GetDlgItemText(hDlg,IDC_NICKNAME,(LPTSTR)&cfg.cp.szNickName,
						                       sizeof(cfg.cp.szNickName));
					if (iIPA == 0 || iNickName == 0)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NICK_OR_ISP,
									   MB_OK | MB_ICONINFORMATION | MB_HELP,
									   MB_ICONINFORMATION,0);
						SetFocus(hChat2);
						break;
					}
					saClient.sin_family = AF_INET;
					saClient.sin_port = htons(CHAT_PORT);
					saClient.sin_addr.s_addr = inet_addr((const char *)&szClientIP);

					// Comment out for production run.
					//................................
//					SetupNickName();
//					SetupChatButtons();
//					bSendEndMsg = TRUE;
//					CopyMemory(&ck,&MyKey,sizeof(CLIENTKEY));
//					dwMaxClientData = (sizeof(lpSend->data) - MyKey.dwN_Bytes);

					// Start the connect thread.
					//..........................
					hConnectThread = CreateThread(NULL,0,
												 (LPTHREAD_START_ROUTINE)ConnectThread,
												 NULL,0,&dwConnectThreadID);
					if (!hConnectThread)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOCONNECTTHREAD,
									   MB_ICONSTOP | MB_OK,MB_ICONSTOP,0);
					}
				}
				break;

				case IDC_NOTIFY:
				{
					// Make sure we have a nickname entered before we notify anyone.
					//..............................................................
					ZeroMemory(&cfg.cp.szNickName,sizeof(cfg.cp.szNickName));

					GetDlgItemText(hDlg,IDC_NICKNAME,(LPTSTR)&cfg.cp.szNickName,
								   sizeof(cfg.cp.szNickName));

					// We need a nickname before we can proceed.
					//..........................................
					if (lstrlen((LPCTSTR)&cfg.cp.szNickName) == 0)
					{
						MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NICKNAME_REQ,
									   MB_OK | MB_ICONINFORMATION | MB_HELP,
									   MB_ICONINFORMATION,0);
						SetFocus(hChat2);
						break;
					}
					// Send a notification message with the IP address we are
					// listening on.
					//.......................................................
					SendNotificationMsg();
					EmptyTheMessageQue();
					SetFocus(hChat2);
				}
				break;

				case IDC_CHAT_SPELL:
				{
//					UINT		uCheck;
//					SHORT		sError;

//					uCheck = IsDlgButtonChecked(hChatSession,IDC_CHAT_SPELL);

//					if (uCheck == BST_CHECKED)
//					{
//						uCheck = BST_UNCHECKED;
//						hCtrlWin = 0;
//					}
//					else
//					{
//						uCheck = BST_CHECKED;
//						hCtrlWin = hChat2;
//					}
//					CheckDlgButton(hChatSession,IDC_CHAT_SPELL,uCheck);
//					sError = SSCE_CheckCtrlBackground(hCtrlWin,MarkOptions,MarkColor);
//					SentrySpellError(sError);
					SetFocus(hChat2);
				}
				break;

				case IDC_DISPLAY:
				{
					iResult = DialogBox(hInst,TEXT("CHATPROPERTIES"),hMainWindow,
									   (DLGPROC)ChatPropertiesProc);
					if (iResult == -1)
					{
						ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
					}
					EmptyTheMessageQue();
					SetFocus(hChat2);
				}
				break;

				case IDC_SENDFONT: 
				{
					SelectCharFormatChat(hMainWindow,hChat2);
					EmptyTheMessageQue();
					SetFocus(hChat2);
				}
				break;

				case IDC_SENDTXTCLR:
				{
					CHARRANGE		cr;
					COLORREF		CurrentColor;

					CurrentColor = cfg.cp.cfSend.crTextColor;
					SendDlgItemMessage(hDlg,IDC_CHAT2,EM_EXGETSEL,0,(LPARAM)&cr);

					ZeroMemory(&crChatText,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;

					crChatText.lStructSize = sizeof(CHOOSECOLOR);
					crChatText.hwndOwner = hMainWindow;
					crChatText.rgbResult = cfg.cp.cfSend.crTextColor;
					crChatText.lpCustColors = (LPDWORD)cfg.crTextCustom;
					crChatText.lpfnHook = MyCCHookProc;
					crChatText.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crChatText))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// Get the current font information from the rich edit control.
						//.............................................................
						SendMessage(hChat2,EM_GETCHARFORMAT,(WPARAM)TRUE,
								   (LPARAM)&cfg.cp.cfSend);
						cfg.cp.cfSend.crTextColor = crChatText.rgbResult;
						SetFocus(hChat2);
						SendMessage(hChat2,EM_SETCHARFORMAT,SCF_SELECTION,
								   (LPARAM)&cfg.cp.cfSend);
						if (cr.cpMax != cr.cpMin)
						{
							cfg.cp.cfSend.crTextColor = CurrentColor;
						}
					}
					EmptyTheMessageQue();
					SetFocus(hChat2);
				}
				break;

				case IDC_SEND:
				{
					EnableWindow(GetDlgItem(hDlg,IDC_SEND),FALSE);
					bSendingMsg = TRUE;

					// If nothing to send bail out.
					//.............................
					cb = 0;
					cLines = SendDlgItemMessage(hDlg,IDC_CHAT2,EM_GETLINECOUNT,0,0L);

					if (cLines)
					{
						// Get the total number of bytes in the multi-line.
						//.................................................
						cb = SendDlgItemMessage(hDlg,IDC_CHAT2,EM_LINEINDEX,
											   (UINT)cLines - 1,0L);
						cb += SendDlgItemMessage(hDlg,IDC_CHAT2,EM_LINELENGTH,(UINT)cb,0L);
					}
					if (!cb)
					{
						bSendingMsg = FALSE;
						EnableWindow(GetDlgItem(hDlg,IDC_SEND),TRUE);
						break;
					}
					// If we are not connected, bail out.
					//...................................
					if (!bBusy)
					{
						EditPrintf(hChat3,TEXT("Not connected, cannot send a message.\r\n\r\n"));
						bMessageBeingTyped = FALSE;
						bSendingMsg = FALSE;
						EnableWindow(GetDlgItem(hDlg,IDC_SEND),TRUE);
						break;
					}
					// Wait until the send thread is done before we send another message.
					//...................................................................
					if (hSendThread)
					{
						while(TRUE)
						{
							GetExitCodeThread(hSendThread,&dwExitCode);
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hSendThread);
								hSendThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					// Send the message.
					//..................
					EncryptAndSendMsg();
				}
				break;

				case IDC_SAVE_CHAT:
				{
					SaveChatAs(hDlg,IDC_CHAT1);
					SetFocus(hChat2);
				}
				break;

				case IDCANCEL:
				case IDC_CHAT_CLOSE:
				{
					KillTimer(hDlg,MY_TIMER);

					if (bSendEndMsg)
					{
						SendMyMsg(&saClient,&mhEndChat,sizeof(MSGHDR));
					}
					Sleep(2000);

//					if (hCtrlWin)
//					{
//						hCtrlWin = 0;
//						SSCE_CheckCtrlBackground(hCtrlWin,MarkOptions,MarkColor);
//					}
					// Clear our three rtf windows.
					//.............................
					ClearMsg();

					// Set the two readonly rtf edit boxes back to normal.
					//....................................................
					SendMessage(hChat1,EM_SETOPTIONS,ECOOP_AND,
								ECO_AUTOVSCROLL | ECO_WANTRETURN);
					SendMessage(hChat3,EM_SETOPTIONS,ECOOP_AND,
								ECO_AUTOVSCROLL | ECO_WANTRETURN);

					// Clear chat1 and chat3 edit boxes.
					//..................................
					cr.cpMin = 0;
					cr.cpMax = -1;
					SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&cr);
					SendMessage(hChat1,WM_CLEAR,0,0);

					cr.cpMin = 0;
					cr.cpMax = -1;
					SendMessage(hChat3,EM_EXSETSEL,0,(LPARAM)&cr);
					SendMessage(hChat3,WM_CLEAR,0,0);

					SetDlgItemText(hDlg,IDC_ISP,lpszNullString);
					SetDlgItemText(hDlg,IDC_CLIENTISP,lpszNullString);
					DestroyWindow(hDlg);

					// This has to be called from here because if you enabled the
					// spell checker in the background it some how prevents this
					// message from being sent or received in the WM_DESTROY case.
					//............................................................
					SetEvent(hChatEvent);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
					SetFocus(hChat2);
				}
				break;

				case IDC_CHAT_SMILEY:
				{
					bFromChat = TRUE;
					GetMySmileys();
					SetFocus(hChat2);
				}
				break;
			}
		}
		break;

		case WM_TIMER:
		{
			if (wParam != MY_TIMER && wParam != SEND_TIMER)
			{
				break;
			}
			if (wParam == SEND_TIMER)
			{
				ClearMsg();
				EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
				KillTimer(hChatSession,SEND_TIMER);
				bMessageBeingTyped = FALSE;
				break;
			}
			// Process the check online timer.
			//................................
			if (bOnline && !bSendingMsg && !bProcessingMsg)
			{
				// Check to see if we are still online or not.
				//............................................
				if (cfg.dwDialupNetwork)
				{
					// We are using dial-up networking to connect.
					//............................................
					bOnline = WeAreOnline2();
				}
				else
				{
					// We are not using dial-up networking to connect.
					//................................................
					bOnline = WeAreOnline(FALSE);
					EnableWindow(GetDlgItem(hDlg,IDC_DIAL),FALSE);
				}
				// If we are not online, shut everything down and reset the dialog box.
				//.....................................................................
				if (!bOnline)
				{
					// Close the connect thread.
					//..........................
					if (hConnectThread)
					{
						EditPrintf(hChat3,TEXT("Shutting Down Connect Thread...\r\n"));
						dwTimeOut = GetTickCount() + 2000;

						while(TRUE)
						{
							if (GetTickCount() >= dwTimeOut)
							{
								EditPrintf(hChat3,TEXT("Close Connect Thread Timed Out.\r\n"));
								Sleep(2000);
								break;
							}
							bResult = GetExitCodeThread(hConnectThread,&dwExitCode);
							if (!bResult)
							{
								ErrorProcedure(TEXT("Connect Thread"),IDS_GETEXITCODETHRD,
											   MB_OK);
								break;
							}
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hConnectThread);
								hConnectThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					// Close the send thread.
					//.......................
					if (hSendThread)
					{
						EditPrintf(hChat3,TEXT("Shutting Down Send Thread...\r\n"));
						dwTimeOut = GetTickCount() + 2000;

						while(TRUE)
						{
							if (GetTickCount() >= dwTimeOut)
							{
								EditPrintf(hChat3,TEXT("Close Send Thread Timed Out.\r\n"));
								Sleep(2000);
								break;
							}
							bResult = GetExitCodeThread(hSendThread,&dwExitCode);
							if (!bResult)
							{
								ErrorProcedure(TEXT("Send Thread"),IDS_GETEXITCODETHRD,MB_OK);
								break;
							}
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hSendThread);
								hSendThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					// Close our socket and threads.
					//..............................
					if (bReceiveActive == TRUE)
					{
						EditPrintf(hChat3,TEXT("Shutting Down Receive Thread...\r\n"));
						if (sock)
						{
							closesocket(sock);
							sock = 0;
						}
						while(bReceiveActive == TRUE)
						{
							Sleep(10);
						}
						dwTimeOut = GetTickCount() + 2000;

						while(TRUE)
						{
							if (GetTickCount() >= dwTimeOut)
							{
								EditPrintf(hChat3,TEXT("Close Receive Thread Timed Out.\r\n"));
								Sleep(2000);
								break;
							}
							bResult = GetExitCodeThread(hReceiveThread,&dwExitCode);
							if (!bResult)
							{	
								ErrorProcedure(TEXT("Receive Thread"),IDS_GETEXITCODETHRD,
											   MB_OK);
								break;
							}
							if (dwExitCode != STILL_ACTIVE)
							{
								CloseHandle(hReceiveThread);
								hReceiveThread = 0;
								break;
							}
							Sleep(10);
						}
					}
					if (cfg.dwDialupNetwork)
					{
						EnableWindow(GetDlgItem(hDlg,IDC_DIAL),TRUE);
					}
					if (bHaveMAPI)
					{
						EnableWindow(GetDlgItem(hChatSession,IDC_NOTIFY),FALSE);
					}
					EnableWindow(GetDlgItem(hChatSession,IDC_CONNECT),FALSE);
					EnableWindow(GetDlgItem(hChatSession,IDC_SEND),FALSE);
					EnableWindow(GetDlgItem(hChatSession,IDC_ENDCHAT),FALSE);
					bBusy = FALSE;
					bIamTheSlave = TRUE;
					dwCallStatus = CHAT_PENDING;
					bHaveClientKey = FALSE;
					bProcessingMsg = FALSE;
					bSendingMsg = FALSE;
					bMessageBeingTyped = FALSE;
					dwMessageNumber = 0;
					bSendEndMsg = FALSE;
					bWaitOnProcessing = FALSE;
					bWaitOnSend = FALSE;

					// Clear the IP addresses.
					//........................
					ZeroMemory(&szIPAddress,sizeof(szIPAddress));
					ZeroMemory(&szClientIP,sizeof(szClientIP));
					SetDlgItemText(hDlg,IDC_ISP,lpszNullString);
					SetDlgItemText(hDlg,IDC_CLIENTISP,lpszNullString);
					lpIPAddress = 0;
					bIPAddress = FALSE;
					bWeDialedInternet = FALSE;
					EditPrintf(hChat3,TEXT("Your connection to the Internet has been lost.\r\nThe Chat dialog box is reset.\r\n\r\n"));
					SetFocus(hChat2);
					ClearMsg();
				}
			}
			return(0);
		}
		break;

		case WM_ACTIVATE:
		{
			if (wParam == 0)
			{
				hDlgCurrent = NULL;
			}
			else
			{
				hDlgCurrent = hDlg;
			}
			return(FALSE);
		}

		case WM_DESTROY:
		{
			// Notify the chat procedure it can continue and close.
			//.....................................................
			SetEvent(hChatEvent);
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			if ((HWND)wParam != hChat2)
			{
				WhatsThis(hDlg,(HWND)wParam,lParam);
			}
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Encrypt and send a message.
//............................
VOID EncryptAndSendMsg()
{
	LPBYTE			lpPke;
	WORD			wBits;
	DATAMSG			dmTemp;
	LPBYTE			lpTemp;
	CHARRANGE		cr;

	bWaitOnProcessing = TRUE;
	while(bProcessingMsg)
	{
		EmptyTheMessageQue();
		Sleep(5);
	}
	bWaitOnProcessing = FALSE;

	// Set up the message to send.
	//............................
	ZeroMemory(lpSend,sizeof(DATAMSG));
	lpSend->hdr.signature = CHAT_SIGNATURE;
	lpSend->hdr.command = CHAT_ENCRYPTED_DATA;

	// Stream the data out of the rtf control.
	//........................................
	dwPageCount = 0;
	lpOutBuffer = lpSend->data;

	eStreamSend.dwCookie = dwMaxClientData;
	eStreamSend.dwError = 0;
	eStreamSend.pfnCallback = EditStreamPageOutCallback;

	SendMessage(hChat2,EM_STREAMOUT,(WPARAM)SF_RTF,(LPARAM)&eStreamSend);
	if (eStreamSend.dwError)
	{
		EditPrintf(hChat3,TEXT("Message too large for %u byte buffer. Message not sent.\r\n\r\n"),
				   dwMaxClientData);
		bSendingMsg = FALSE;
		return;
	}
	lpSend->hdr.length = dwPageCount;
	lpSend->hdr.dwDataLength = dwPageCount;
	
	// Calculate the pointer for inserting the pke packet.
	//....................................................
	lpPke = (lpSend->data + dwPageCount);

	// Make sure we append to the end of the text.
	//............................................
	SetFocus(hChat1);
	cr.cpMin = -1;
	cr.cpMax = -1;
	SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&cr);

	// Display the original message.
	//..............................
	dwPageCount = lstrlen((LPCTSTR)&MyKey.szClientName);
	lpOutBuffer = MyKey.szClientName;
	eStreamSend.dwCookie = (DWORD)lpOutBuffer;
	eStreamSend.dwError = 0;
	eStreamSend.pfnCallback = EditStreamPageInCallback;

	SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,(LPARAM)&eStreamSend);

	// Get the result of the operation.
	//.................................
	if (eStreamSend.dwError)
	{
		EditPrintf(hChat3,TEXT("Could not display our nickname.\r\n"));
	}

	dwPageCount = lpSend->hdr.dwDataLength;
	lpOutBuffer = lpSend->data;
	eStreamSend.dwCookie = (DWORD)lpOutBuffer;
	eStreamSend.dwError = 0;
	eStreamSend.pfnCallback = EditStreamPageInCallback;

	SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_RTF | SFF_SELECTION,(LPARAM)&eStreamSend);
	if (eStreamSend.dwError)
	{
		EditPrintf(hChat3,TEXT("Could not display outgoing chat message.\r\n"));
	}
	SendMessage(hChat1,EM_SCROLL,SB_PAGEDOWN,0);

	EmptyTheMessageQue();

	// Insert any smileys in the outgoing message.
	//............................................
	CheckandInsertSmileys();

	// Setup the random number generators.
	//....................................
	bCancelOperation = FALSE;
	ClearAllVariables();
	ClearMathVariables();

	SetupDiaryRngs(ck.dwN_Bytes);

	RsaPubEnc(&Temp1,(LPBYTE)&rphdr,dwReproLength,(LPBYTE)&ck.E_Temp,(LPBYTE)&ck.Modn,
			  ck.dwN_Bytes);
	if (bCancelOperation == TRUE)
	{
		EditPrintf(hChat3,TEXT("Encryption of message cancelled. Message not sent.\r\n\r\n"));
		bSendingMsg = FALSE;
		return;
	}
	__asm
	{
		mov		eax,dwCountBits
		xchg	ah,al
		mov		wBits,ax
	}
	lpSend->hdr.MPI_PREFIX = wBits;
	lpSend->hdr.dwPkeLength = dwCountBytes;
	CircleSwap((LPBYTE)&Temp1,dwCountBytes);

	// Copy the pke packet to the send packet.
	//........................................
	CopyMemory(lpPke,&Temp1,dwCountBytes);
	lpSend->hdr.length += dwCountBytes;

	// Setup the arrays for encrypting the message.
	//.............................................
	SetupDiaryArrays();
	Divisor1 = 256;
	dwPageCount = lpSend->hdr.dwDataLength;

	// Encrypt the message.
	//.....................
	ChangeBytes(lpSend->data,dwPageCount);

	// Display the encrypted message in the bottom window.
	//....................................................
	CopyMemory(&dmTemp,lpSend,sizeof(DATAMSG));
	dwPageCount = dmTemp.hdr.dwDataLength;

	// Convert invalid characters to periods.
	//......................................
	lpTemp = (LPBYTE)&dmTemp.data;

	__asm
	{
		mov		esi,lpTemp
		mov		edi,lpTemp
		mov		ecx,dwPageCount
	L1:	lodsb
		cmp		al,20h
		jb		L2
		cmp		al,7fh
		jb		L3
		cmp		al,91h
		je		L3
		cmp		al,92h
		je		L3
		cmp		al,9fh
		ja		L3
	L2:	mov		al,2eh
	L3:	stosb
		dec		ecx
		jnz		L1
	}
	// Make sure we append to the end of the text.
	//............................................
	SetFocus(hChat3);
	cr.cpMin = -1;
	cr.cpMax = -1;
	SendMessage(hChat3,EM_EXSETSEL,0,(LPARAM)&cr);

	// Display the encrypted outgoing message in the bottom panel.
	// Display our nickname first.
	//...........................................................
	dwPageCount = lstrlen((LPCTSTR)&MyKey.szClientName);
	lpOutBuffer = MyKey.szClientName;
	eStreamSend.dwCookie = (DWORD)lpOutBuffer;
	eStreamSend.dwError = 0;
	eStreamSend.pfnCallback = EditStreamPageInCallback;

	SendMessage(hChat3,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,(LPARAM)&eStreamSend);

	// Get the result of the operation.
	//.................................
	if (eStreamSend.dwError)
	{
		EditPrintf(hChat3,TEXT("Could not display our nickname.\r\n"));
	}
	// Display the encrypted data.
	//............................
	dwPageCount = dmTemp.hdr.dwDataLength;
	lpOutBuffer = (LPBYTE)&dmTemp.data;
	eStreamSend.dwCookie = (DWORD)lpOutBuffer;
	eStreamSend.dwError = 0;
	eStreamSend.pfnCallback = EditStreamPageInCallback;

	SendMessage(hChat3,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,(LPARAM)&eStreamSend);
	if (eStreamSend.dwError)
	{
		EditPrintf(hChat3,TEXT("Could not display outgoing encrypted data.\r\n"));
	}
	EditPrintf(hChat3,TEXT("\r\n\r\n"));
	SendMessage(hChat3,EM_SCROLL,SB_PAGEDOWN,0);

	// Send the encrypted message.
	//............................
	SendChat(sizeof(MSGHDR) + lpSend->hdr.length);
	bSendingMsg = FALSE;
	SetTimer(hChatSession,SEND_TIMER,122880,NULL);
}

// Send chat message.
//...................
VOID SendChat(int iMsgLength)
{
	DWORD		dwExitCode;

	iChatMsgLength = iMsgLength;

	// Wait until the send thread is done before we send another message.
	//...................................................................
	if (hSendThread)
	{
		while(TRUE)
		{
			GetExitCodeThread(hSendThread,&dwExitCode);
			if (dwExitCode != STILL_ACTIVE)
			{
				CloseHandle(hSendThread);
				hSendThread = 0;
				break;
			}
			Sleep(10);
		}
	}
	dwSendStatus = CHAT_MSG_SENT;
	dwChatRetry = 5;

	hSendThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)SendThread,
							   NULL,0,&dwSendThreadID);
	if (!hSendThread)
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NOSENDTHREAD,MB_ICONSTOP | MB_OK,
					   MB_ICONSTOP,0);
	}
}

// Thread for sending packets.
//............................
DWORD WINAPI SendThread(LPVOID lpParam)
{
	while(TRUE)
	{
		SendMyMsg(&saClient,lpSend,iChatMsgLength);
		if (--dwChatRetry == 0 || dwSendStatus == CHAT_MSG_ACK)
		{
			break;
		}
		Sleep(1000);
	}
	if (dwSendStatus != CHAT_MSG_ACK)
	{
		// They did not acknowledge our message or key.
		//.............................................
		if (lpSend->hdr.command == CHAT_SEND_KEY)
		{
			EditPrintf(hChat3,TEXT("%s at %s did not acknowledge receipt of our public key.\r\nWait for another connection attempt or try to connect yourself.\r\n\r\n"),
				       ck.szClientName,szClientIP);
		}
		else
		{
			EditPrintf(hChat3,TEXT("%s at %s did not acknowledge your last message.\r\nTry to send it again.\r\n\r\n"),
					   ck.szClientName,szClientIP);
			EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
			KillTimer(hChatSession,SEND_TIMER);
			bMessageBeingTyped = FALSE;
		}
	}
	ExitThread(1);
	return(1);
}

// Send a message.
//................
VOID SendMyMsg(struct sockaddr_in *addr, void *buf, int iLen)
{
	sendto(sock,(char *)buf,iLen,0,(struct sockaddr *)addr,sizeof(struct sockaddr_in));
}

// Send an ack message.
//.....................
VOID SendAckMsg(struct sockaddr_in *addr, void *buf, int iLen)
{
	sendto(sock,(char *)buf,iLen,0,(struct sockaddr *)addr,sizeof(struct sockaddr_in));
}

// Send a Type message.
//.....................
VOID SendTypeMsg(struct sockaddr_in *addr, void *buf, int iLen)
{
	sendto(sock,(char *)buf,iLen,0,(struct sockaddr *)addr,sizeof(struct sockaddr_in));
}

// Thread for connecting to client.
//.................................
DWORD WINAPI ConnectThread(LPVOID lpParam)
{
	int				iRetry;
	DWORD			dwTimeOut;

	bIamTheSlave = FALSE;

	for (iRetry = 0; iRetry < 5; iRetry++)
	{
		dwTimeOut = GetTickCount() + 1000;
		
		// Setup our key to transmit.
		//...........................
		lpSend->hdr.signature = CHAT_SIGNATURE;
		lpSend->hdr.command = CHAT_KEY;
		lpSend->hdr.ack = 0;
		lpSend->hdr.length = sizeof(CLIENTKEY);
		SetupNickName();
		CopyMemory(lpSend->data,&MyKey,sizeof(CLIENTKEY));

		// Send our key.
		//..............
		SendMyMsg(&saClient,lpSend,sizeof(MSGHDR) + sizeof(CLIENTKEY));

		while(dwCallStatus == CHAT_PENDING && GetTickCount() < dwTimeOut)
		{
			Sleep(10);
		}
		if (dwCallStatus == CHAT_REQ_KEY)
		{
			lpSend->hdr.signature = CHAT_SIGNATURE;
			lpSend->hdr.command = CHAT_SEND_KEY;
			lpSend->hdr.ack = 0;
			lpSend->hdr.length = 0;
			SendMyMsg(&saClient,lpSend,sizeof(MSGHDR));
			break;
		}
	}
	if (iRetry == 5 && dwCallStatus == CHAT_PENDING)
	{
		EditPrintf(hChat3,TEXT("Did not receive acknowledgement for your key packet.\r\nTry to connect again.\r\n\r\n"));
	}
	ExitThread(1);
	return(1);
}

// Thread for receiving packets.
//..............................
DWORD WINAPI ReceiveThread(LPVOID lpParam)
{
	int				addrlen;
	int				len;
	struct timeval	tv;
	struct fd_set	fs;
	LPBYTE			lpAddr;
	DWORD			dwResult;
	DATAMSG			dmTemp;
	LPBYTE			lpTemp;
	DWORD			dwCount;
	LPBYTE			lpPke;
	BOOL			bError;
	DWORD			dwRsaIntegerBits;
	DWORD			dwRsaIntegerBytes;
	DWORD			dwCheckSum;
	DWORD			dwHdrCheckSum;
	BOOL			bResult;
	BYTE			KeyIdC[12];
	CHARRANGE		cr;

	bReceiveActive = TRUE;

	while(sock)
	{
		addrlen = sizeof(saTemp);
		tv.tv_sec = 1;
		tv.tv_usec = 0;
		FD_ZERO(&fs);
		FD_SET(sock,&fs);
		select(0,&fs,0,0,&tv);

		// We are closed down. Exit the thread.
		//.....................................
		if(!sock)
		{
			break;
		}
		if(!FD_ISSET(sock,&fs))
		{
			continue;
		}
		ZeroMemory(lpReceive,sizeof(DATAMSG));

		// Receive some data.
		//...................
		len = recvfrom(sock,(char *)lpReceive,sizeof(DATAMSG),0,(LPSOCKADDR)&saTemp,&addrlen);

		if (len == SOCKET_ERROR && WSAGetLastError() == WSAECONNRESET)
		{
			EditPrintf(hChat3,TEXT("%s at %s has closed his connection.\r\nContinuing to listen for incoming connections.\r\n\r\n"),
					   ck.szClientName,szClientIP);
			bSendEndMsg = FALSE;
			PostMessage(hChatSession,WM_COMMAND,IDC_ENDCHAT,0);
			continue;
		}
		else if (len == SOCKET_ERROR)
		{
			EditPrintf(hChat3,TEXT("recvfrom error #%i. Continuing to listen for incoming messages.\r\n\r\n"),
					   WSAGetLastError());
			continue;
		}
		if (len < 1)
		{
			continue;
		}
		if (lpReceive->hdr.signature == CHAT_SIGNATURE && 
		   (lpReceive->hdr.command >= CHAT_KEY && lpReceive->hdr.command <= CHAT_TYPING_MSG))
		{
			bProcessingMsg = TRUE;

			switch(lpReceive->hdr.command)
			{
				case CHAT_KEY:
				{
					// If we are already busy, refuse connection.
					//...........................................
					if (bBusy)
					{
						// Someone is trying to send us a key when we are
						// already chatting with another.
						//...............................................
						break;
					}
					// Are we accepting the call or responding to it.
					//...............................................
					if (bIamTheSlave)
					{
						if (lpReceive->hdr.ack == 0)
						{
							if (!bHaveClientKey)
							{
								// Received connect from client.
								//..............................
								CopyMemory(&saClient,&saTemp,sizeof(saTemp));
								lpAddr = inet_ntoa(saClient.sin_addr);
								CopyMemory(&szClientIP,lpAddr,sizeof(szClientIP));
								SetDlgItemText(hChatSession,IDC_CLIENTISP,
											  (LPCTSTR)&szClientIP);

								// Copy the key data to ck.
								//.........................		
								CopyMemory(&ck,lpReceive->data,sizeof(CLIENTKEY));
								bHaveClientKey = TRUE;
								dwMaxClientData = (sizeof(lpSend->data) - ck.dwN_Bytes);
								EditPrintf(hChat3,TEXT("Received key from %s at %s.\r\n"),
										   ck.szClientName,szClientIP);

								// See if we have a key id from our key ring.
								//...........................................
								ZeroMemory(&KeyIdC,sizeof(KeyIdC));
								ChangeToHex(SHORT_KEY_ID,(LPBYTE)&ck.ChatKeyID[4],
										   (LPBYTE)&KeyIdC,FORWARD);

								bResult = ChatKeyUserID((LPBYTE)&ck.ChatKeyID);
								if (bResult)
								{
									EditPrintf(hChat3,TEXT("Key ID: %s - User ID: %s\r\n"),
											   KeyIdC,TempUserId);
								}
								else
								{
									EditPrintf(hChat3,TEXT("Key ID: %s - User ID: Not on our Public Key Ring.\r\n"),
											   KeyIdC);
								}
							}
							// Only acknowledge message from our client.
							//..........................................
							if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
								saClient.sin_port == saTemp.sin_port)
							{
								lpReceive->hdr.ack = 1;
								lpReceive->hdr.length = 0;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
							}
						}
						else if (lpReceive->hdr.ack == 1)
						{
							// They received our key.
							//.......................
							dwSendStatus = CHAT_MSG_ACK;
							SetupChatButtons();
						}
					}
					else
					{
						// I am the master.
						//.................
						if (lpReceive->hdr.ack == 1)
						{
							// We received acknowledgement of receipt of our key.
							// Now send request for their key.
							//...................................................
							dwCallStatus = CHAT_REQ_KEY;
						}
						else if (lpReceive->hdr.ack == 0)
						{
							// Only accept a key from our client.
							//...................................
							if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
								saClient.sin_port == saTemp.sin_port)
							{
								// We are receiving the clients public key.
								//.........................................
								if (!bHaveClientKey)
								{
									CopyMemory(&ck,lpReceive->data,sizeof(CLIENTKEY));
									bHaveClientKey = TRUE;
									dwMaxClientData = (sizeof(lpSend->data) - ck.dwN_Bytes);
									EditPrintf(hChat3,TEXT("Received key from %s at %s.\r\n"),
											   ck.szClientName,szClientIP);

									// See if we have a key id from our key ring.
									//...........................................
									ZeroMemory(&KeyIdC,sizeof(KeyIdC));
									ChangeToHex(SHORT_KEY_ID,(LPBYTE)&ck.ChatKeyID[4],
											   (LPBYTE)&KeyIdC,FORWARD);

									bResult = ChatKeyUserID((LPBYTE)&ck.ChatKeyID);
									if (bResult)
									{
										EditPrintf(hChat3,TEXT("Key ID: %s - User ID: %s\r\n"),
												   KeyIdC,TempUserId);
									}
									else
									{	
										EditPrintf(hChat3,TEXT("Key ID: %s - User ID: Not on our Public Key Ring.\r\n"),
												   KeyIdC);
									}
									SetupChatButtons();
								}
								lpReceive->hdr.ack = 1;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
							}
						}
					}
				}
				break;

				case CHAT_ENCRYPTED_DATA:
				{
					if (lpReceive->hdr.ack == 0)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port)
						{
							// Disable the send commnad button.
							//.................................
							lpReceive->hdr.ack = 1;
							SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));

							// Check for a duplicate message received.
							//........................................
							dwResult = MpCompareStrings((LPBYTE)lpReceive->data,
													   (LPBYTE)lpPrevious->data,
														lpReceive->hdr.dwDataLength);
							if (dwResult == 0)
							{
								// Duplicate message.
								//...................
								break;
							}
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),FALSE);
							EditPrintf(hChat3,TEXT("Send Command Button disabled while decrypting incoming message.\r\n\r\n"));

							// Wait for any message being sent.
							//.................................
							bWaitOnSend = TRUE;
							while(bSendingMsg)
							{
								if (bWaitOnSend && bWaitOnProcessing)
								{
									break;
								}
								EmptyTheMessageQue();
								Sleep(5);
							}
							bWaitOnSend = FALSE;

							CopyMemory(lpPrevious,lpReceive,sizeof(DATAMSG));
							CopyMemory(&dmTemp,lpReceive,sizeof(DATAMSG));

							// Convert and display the incomming encrypted data.
							//..................................................
							lpTemp = (LPBYTE)&dmTemp.data;
							dwCount = dmTemp.hdr.dwDataLength;

							__asm
							{
								mov		esi,lpTemp
								mov		edi,lpTemp
								mov		ecx,dwCount
							L1:	lodsb
								cmp		al,20h
								jb		L2
								cmp		al,7fh
								jb		L3
								cmp		al,91h
								je		L3
								cmp		al,92h
								je		L3
								cmp		al,9fh
								ja		L3
							L2:	mov		al,2eh
							L3:	stosb
								dec		ecx
								jnz		L1
							}
							// Make sure we append to the end of the text.
							//............................................
							SetFocus(hChat3);
							cr.cpMin = -1;
							cr.cpMax = -1;
							SendMessage(hChat3,EM_EXSETSEL,0,(LPARAM)&cr);

							// Display the encrypted incoming message in the bottom panel.
							// Display the client's nickname first.
							//...........................................................
							dwPageCount = lstrlen((LPCTSTR)&ck.szClientName);
							lpOutBuffer = ck.szClientName;
							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat3,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);

							// Get the result of the operation.
							//.................................
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display client's nickname.\r\n"));
							}

							dwPageCount = dmTemp.hdr.dwDataLength;
							lpOutBuffer = (LPBYTE)&dmTemp.data;
							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat3,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display incoming encrypted data.\r\n"));
							}	
							EditPrintf(hChat3,TEXT("\r\n\r\n"));
							SendMessage(hChat3,EM_SCROLL,SB_PAGEDOWN,0);

							// Decrypt the message.
							//.....................
							ClearAllVariables();
							ClearMathVariables();
							lpPke = (lpReceive->data + lpReceive->hdr.dwDataLength);

							dwRsaIntegerBits = (WORD)lpReceive->hdr.MPI_PREFIX;

							__asm
							{
								mov		eax,dwRsaIntegerBits
								xchg	ah,al
								mov		dwRsaIntegerBits,eax
								add		eax,7
								shr		eax,3
								mov		dwRsaIntegerBytes,eax
							}
							// Decipher the secret key components.
							//....................................
							DecComponents();
							CopyMemory(&Temp9,lpPke,dwRsaIntegerBytes);
							CircleSwap((LPBYTE)&Temp9,dwRsaIntegerBytes);

							// Check out the pke packet.
							//..........................
							if (dwRsaIntegerBits > lpMyKey->dwN_Bits)
							{
								EditPrintf(hChat3,TEXT("Invalid or corrupted Public Key Encrypted Packet.\r\nCannot decrypt message.\r\n\r\n"));
								lpReceive->hdr.ack = 3;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
								EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
								break;
							}
							if (dwRsaIntegerBits == lpMyKey->dwN_Bits)
							{
								dwResult = MpCompareDW((LPBYTE)lpMyKey->Modulus_N,
													  (LPBYTE)&Temp9,MAX_MOD_DWORD);
								if (dwResult == 0 || dwResult == 1)
								{
									EditPrintf(hChat3,TEXT("Invalid or corrupted Public Key Encrypted Packet.\r\nCannot decrypt message.\r\n\r\n"));
									lpReceive->hdr.ack = 3;
									SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
									EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
									break;
								}
							}
							bCancelOperation = FALSE;

							bError = RsaPriDec((LPBYTE)&Temp6,(LPBYTE)&Temp9,
										      (LPBYTE)lpMyKey->D_Temp,
											  (LPBYTE)lpMyKey->Prime_P,
											  (LPBYTE)lpMyKey->Prime_Q,
											  (LPBYTE)lpMyKey->U_Temp,lpMyKey->dwN_Bytes);

							EncComponents();

							if (bError)
							{
								EditPrintf(hChat3,TEXT("Error decrypting the Public Key Encrypted Packet.\r\nCannot decrypt message.\r\n\r\n"));
								lpReceive->hdr.ack = 3;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
								EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
								break;
							}
							// Setup the random key to decipher the diary file.
							//.................................................
							if (dwCountBytes == KEY_4_LGTH || dwCountBytes == KEY_8_LGTH ||
								dwCountBytes == KEY_16_LGTH || dwCountBytes == KEY_32_LGTH ||
								dwCountBytes == KEY_64_LGTH || dwCountBytes == KEY_128_LGTH)
							{
								dwReproLength = dwCountBytes;
								CopyMemory(&rphdr,&Temp6,dwCountBytes);
							}
							else
							{
								// We have a key length we cannot deal with.
								//..........................................
								EditPrintf(hChat3,TEXT("Invalid key length. We cannot decrypt the message.\r\n\r\n"));
								lpReceive->hdr.ack = 3;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
								EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
								break;
							}
							// Check out the checksum to make sure it is correct.
							//...................................................
							lpCsumOffset = (LPBYTE)&rphdr;
							lpSeedOffset = (LPBYTE)&rphdr;

							dwRngsUsed = RNGS_128;

							if (dwReproLength == KEY_4_LGTH)
							{
								dwRngsUsed = RNGS_4;
							}
							else if (dwReproLength == KEY_8_LGTH)
							{
								dwRngsUsed = RNGS_8;
							}
							else if (dwReproLength == KEY_16_LGTH)
							{
								dwRngsUsed = RNGS_16;
							}			
							else if (dwReproLength == KEY_32_LGTH)
							{
								dwRngsUsed = RNGS_32;
							}
							else if (dwReproLength == KEY_64_LGTH)
							{
								dwRngsUsed = RNGS_64;
							}
							lpCsumOffset += (dwReproLength - SIZE_OF_CSUM);
							lpSeedOffset += (dwReproLength - SIZE_OF_CSUM - SIZE_OF_SEED);

							__asm
							{
								mov		eax,dwRngsUsed
								mov		RingMask,al
								dec		RingMask
							}
							// Calculate and check the checksum of the header.
							//................................................
							__asm
							{
								mov		esi,lpCsumOffset
								movzx	eax,word ptr [esi]
								xchg	ah,al
								mov		dwHdrCheckSum,eax
							}
							dwCheckSum = CheckSum((LPBYTE)&rphdr,(dwReproLength - SIZE_OF_CSUM));
							if (dwHdrCheckSum != dwCheckSum)
							{
								EditPrintf(hChat3,TEXT("Invalid checksum for key data. Cannot decrypt message.\r\n\r\n"));
								lpReceive->hdr.ack = 3;
								SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
								EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
								break;
							}
							__asm
							{
								mov		esi,lpSeedOffset
								mov		eax,dword ptr [edi]
								mov		Seed,eax
							}
							// Setup the random number generators.
							// Setup the factor array first, followed by the tops and
							// seeds arrays.
							//.......................................................
							__asm
							{
								mov		eax,dwRngsUsed
								mov		ecx,SIZE_OF_SEED
								mul		ecx
								mov		ecx,eax
								push	ecx
								push	ecx
								mov		esi,offset rphdr
								mov		edi,offset FactorArray
								rep		movsb
								pop		ecx
								mov		edi,offset TopsArray
								rep		movsb
								pop		ecx
								mov		edi,offset SeedsArray
								rep		movsb

								// Setup the first LastSeed value.
								//................................
								mov		al,byte ptr rphdr[12]
								and		al,RingMask
								mov		LastSeed,al

								// Setup the DbleNumber value.
								//............................
								mov		esi,lpSeedOffset
								mov		eax,dword ptr [esi-7]
								clc
								rcl		eax,1
								jnc		L4
								mov		eax,-1
							L4:	mov		DbleNumber,eax
							}
							ZeroMemory(&rphdr,MAX_REPRO_LGTH);
							Divisor1 = 256;

							ChangeBytes(lpReceive->data,lpReceive->hdr.dwDataLength);

							ClearAllVariables();
							ClearMathVariables();

							// Make sure we append to the end of the text.
							//............................................
							SetFocus(hChat1);
							cr.cpMin = -1;
							cr.cpMax = -1;
							SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&cr);
					
							// Display the client's nickname first.
							//.....................................
							dwPageCount = lstrlen((LPCTSTR)&ck.szClientName);
							lpOutBuffer = ck.szClientName;
							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);

							// Get the result of the operation.
							//.................................
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display client's nickname.\r\n"));
							}
							// Display the message.
							//.....................
							dwPageCount = lpReceive->hdr.dwDataLength;

							lpOutBuffer = lpReceive->data;

							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_RTF | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);

							// Get the result of the operation.
							//.................................
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display incoming chat message.\r\n"));
							}
							SendMessage(hChat1,EM_SCROLL,SB_PAGEDOWN,0);

							// Insert any smileys in the outgoing message.
							//............................................
							CheckandInsertSmileys();
							SetFocus(hChat2);

							// Acknowledge decryption of the message.
							//.......................................
							lpReceive->hdr.ack = 2;
							SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);

							// If the program is minimized flash the icon.
							//............................................
							if (IsIconic(hMainWindow))
							{
								FlashWindow(hMainWindow,TRUE);
								NotifyMe();
							}
						}
					}
					else if (lpReceive->hdr.ack == 1)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port && dwSendStatus == CHAT_MSG_SENT)
						{
							// This stops the send thread and prevents us from displaying
							// the message more than once.
							//...........................................................
							dwSendStatus = CHAT_MSG_ACK;
						}
					}
					else if (lpReceive->hdr.ack == 2)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port)
						{
							ClearMsg();
							KillTimer(hChatSession,SEND_TIMER);
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
							bMessageBeingTyped = FALSE;
						}
					}
					else if (lpReceive->hdr.ack == 3)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port)
						{
							// Previous message not successfully decrypted.
							//.............................................
							EditPrintf(hChat3,TEXT("Previous message not successfully decrypted and displayed on client's computer."));
							KillTimer(hChatSession,SEND_TIMER);
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
							bMessageBeingTyped = FALSE;
						}
					}
				}
				break;

				case CHAT_PLAINTEXT:
				{
					if (lpReceive->hdr.ack == 0)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port)
						{
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),FALSE);

							// We are receiving a plaintext message.
							//......................................
							lpReceive->hdr.ack = 1;
							SendAckMsg(&saClient,lpReceive,sizeof(MSGHDR));

							// Check for a duplicate message received.
							//........................................
							dwResult = MpCompareStrings((LPBYTE)lpReceive->data,
													   (LPBYTE)lpPrevious->data,
														lpReceive->hdr.dwDataLength);
							if (dwResult == 0)
							{
								// Duplicate message.
								//...................
								break;
							}
							CopyMemory(lpPrevious,lpReceive,sizeof(DATAMSG));

							// Make sure we append to the end of the text.
							//............................................
							SetFocus(hChat1);
							cr.cpMin = -1;
							cr.cpMax = -1;
							SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&cr);

							// Display the client's nickname first.
							//.....................................
							dwPageCount = lstrlen((LPCTSTR)&ck.szClientName);
							lpOutBuffer = ck.szClientName;
							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_TEXT | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);

							// Get the result of the operation.
							//.................................
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display client's nickname.\r\n"));
							}
							// Display the message.
							//.....................
							dwPageCount = lpReceive->hdr.dwDataLength;
							lpOutBuffer = lpReceive->data;

							eStreamRecv.dwCookie = (DWORD)lpOutBuffer;
							eStreamRecv.dwError = 0;
							eStreamRecv.pfnCallback = EditStreamPageInCallback;

							SendMessage(hChat1,EM_STREAMIN,(WPARAM)SF_RTF | SFF_SELECTION,
									   (LPARAM)&eStreamRecv);

							// Get the result of the operation.
							//.................................
							if (eStreamRecv.dwError)
							{
								EditPrintf(hChat3,TEXT("Could not display incoming chat message.\r\n"));
							}
							SendMessage(hChat1,EM_SCROLL,SB_PAGEDOWN,0);
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);

							// Insert any smileys in the outgoing message.
							//............................................
							CheckandInsertSmileys();
							SetFocus(hChat2);
						}
					}
					else if (lpReceive->hdr.ack == 1)
					{
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port && dwSendStatus == CHAT_MSG_SENT)
						{
							// This stops the send thread and prevents us from displaying
							// the message more than once.
							//...........................................................
							dwSendStatus = CHAT_MSG_ACK;
							bMessageBeingTyped = FALSE;
							ClearMsg();
							KillTimer(hChatSession,SEND_TIMER);
							EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
						}
					}
				}
				break;

				case CHAT_TYPING_MSG:
				{
					dwMessageNumber++;
					SendMessage(hChat3,EM_REPLACESEL,FALSE,(LPARAM)(LPCTSTR)&ck.szClientName);
					EditPrintf(hChat3,TEXT("is typing message number %u.\r\n"),
							   dwMessageNumber);
				}
				break;

				case CHAT_END:
				{
					SendMessage(hChat3,EM_REPLACESEL,FALSE,(LPARAM)(LPCTSTR)&ck.szClientName);
					EditPrintf(hChat3,TEXT("has ended the chat session.\r\n"));
					bSendEndMsg = FALSE;
					PostMessage(hChatSession,WM_COMMAND,IDC_ENDCHAT,0);
				}
				break;

				case CHAT_SEND_KEY:
				{
					if (bIamTheSlave && lpReceive->hdr.ack == 0)
					{
						// Only send a key to our client.
						//...............................
						if (saClient.sin_addr.s_addr == saTemp.sin_addr.s_addr &&
							saClient.sin_port == saTemp.sin_port)
						{
							ZeroMemory(lpSend,sizeof(DATAMSG));
							lpSend->hdr.signature = CHAT_SIGNATURE;
							lpSend->hdr.command = CHAT_KEY;
							lpSend->hdr.ack = 0;
							lpSend->hdr.length = sizeof(CLIENTKEY);
							SetupNickName();
							CopyMemory(lpSend->data,&MyKey,sizeof(CLIENTKEY));
							SendChat(sizeof(MSGHDR) + sizeof(CLIENTKEY));
						}
					}
				}
				break;
			}
			bProcessingMsg = FALSE;
		}
		else
		{
			// Received an improperly formated message.
			//.........................................
			lpAddr = lpAddr = inet_ntoa(saTemp.sin_addr);
			EditPrintf(hChat3,TEXT("Received an improperly formatted message from %s.\r\n\r\n"),lpAddr);
		}
	}
	bReceiveActive = FALSE;
	ExitThread(1);
	return(1);
}

// Setup the command buttons for chatting.
//........................................
VOID SetupChatButtons()
{
	if (bHaveMAPI)
	{
		EnableWindow(GetDlgItem(hChatSession,IDC_NOTIFY),FALSE);
	}
	EnableWindow(GetDlgItem(hChatSession,IDC_CONNECT),FALSE);
	EnableWindow(GetDlgItem(hChatSession,IDC_SEND),TRUE);
	EnableWindow(GetDlgItem(hChatSession,IDC_ENDCHAT),TRUE);
	EnableWindow(GetDlgItem(hChatSession,IDC_SAVE_CHAT),TRUE);
	bBusy = TRUE;
	dwCallStatus = CHAT_IN_PROGRESS;
	bSendFocus = TRUE;
	bSendEndMsg = TRUE;

	EditPrintf(hChat3,TEXT("Public Keys exchanged. You may start your encrypted chat session.\r\n\r\n"));

	// If the program is minimized flash the icon.
	//............................................
	if (IsIconic(hMainWindow))
	{
		FlashWindow(hMainWindow,TRUE);
	}
	NotifyMe();
}

// Initialize the socket to listen on.
//....................................
BOOL InitializeSocket(HWND hStatusWin)
{
	BOOL		bError = TRUE;
	int			iErr;
	int			iSize;

	sock = 0;

	if (!bStartup)
	{
		// Send initializing Winsock message.
		//...................................
		EditPrintf(hStatusWin,TEXT("Initializing Winsock....\r\n"));

		// Initialize Winsock.
		//....................
		if (iErr = WSAStartup(MAKEWORD(1,1),&wsa_data))
		{
			EditPrintf(hStatusWin,TEXT("WSAStartup error #%i.\r\n"),iErr);
			goto InitEnd;
		}
		else
		{
			EditPrintf(hStatusWin,TEXT("Started up %hs.\r\n"),wsa_data.szDescription);
		}
		bStartup = TRUE;
	}
	// Create our socket.
	//...................
	sock = socket(AF_INET,SOCK_DGRAM,IPPROTO_IP);
	if(sock == INVALID_SOCKET)
	{
		EditPrintf(hStatusWin,TEXT("Socket creation error #%i.\r\n"),WSAGetLastError());
		goto InitEnd;
	}
	EditPrintf(hStatusWin,TEXT("Socket %i created.\r\n"),sock);

	ZeroMemory(&sa,sizeof(sa));
	sa.sin_family = AF_INET;
	sa.sin_port = htons(CHAT_PORT);
	sa.sin_addr.s_addr = htonl(INADDR_ANY);
	
	// Bind the listening socket.
	//...........................
	if (bind(sock,(LPSOCKADDR)&sa,sizeof(sa)))
	{
		EditPrintf(hStatusWin,TEXT("Socket bind error #%i.\r\n"),WSAGetLastError());
		goto InitEnd;
	}
	iSize = sizeof(int);
	iErr = getsockopt(sock,SOL_SOCKET,SO_MAX_MSG_SIZE,(char *)&iMaxMsgSize,&iSize);
	if (iErr == SOCKET_ERROR)
	{
		EditPrintf(hStatusWin,TEXT("getsockopt error #%i. Cannot determine maximum message size.\r\n"),
				   WSAGetLastError());
		goto InitEnd;
	}
	// Does the size support our datagram size.
	//.........................................
	if (iMaxMsgSize < sizeof(DATAMSG))
	{
		EditPrintf(hStatusWin,TEXT("Supported datagram message size is less than 8,192 bytes required by the Chat procedure.\r\n"));
		goto InitEnd;
	}
	// Set up receive thread.
	//.......................
	hReceiveThread = CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)ReceiveThread,NULL,0,
								  &dwReceiveThreadID);
	if (!hReceiveThread)
	{
		MessageBoxProc(hMainWindow,IDS_ADVISORY,IDS_NORECEIVETHREAD,MB_ICONSTOP | MB_OK,
					   MB_ICONSTOP,0);
		goto InitEnd;
	}
	EditPrintf(hChat3,TEXT("Listening for incoming connections...\r\n\r\n"));

	bError = FALSE;

	InitEnd:

	if (bError)
	{
		if (sock)
		{
			closesocket(sock);
			sock = 0;
		}
		if (bStartup)
		{
			WSACleanup();
			bStartup = FALSE;
		}
	}
	return(bError);
}

// CALLBACK procedure for setting the fonts and colors.
//.....................................................
LRESULT CALLBACK ChatPropertiesProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_TOPPANEL:
				{
					ZeroMemory(&crChatBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;

					crChatBkg.lStructSize = sizeof(CHOOSECOLOR);
					crChatBkg.hwndOwner = hMainWindow;
					crChatBkg.rgbResult = cfg.cp.crChat1;
					crChatBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crChatBkg.lpfnHook = MyCCHookProc;
					crChatBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crChatBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						cfg.cp.crChat1 = crChatBkg.rgbResult;
						SendMessage(hChat1,EM_SETBKGNDCOLOR,0,
								   (LPARAM)(COLORREF)cfg.cp.crChat1);
						crOleBkg = cfg.cp.crChat1;
					}
					EmptyTheMessageQue();
				}
				break;

				case IDC_MIDDLEPANEL:
				{
					ZeroMemory(&crChatBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;

					crChatBkg.lStructSize = sizeof(CHOOSECOLOR);
					crChatBkg.hwndOwner = hMainWindow;
					crChatBkg.rgbResult = cfg.cp.crChat2;
					crChatBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crChatBkg.lpfnHook = MyCCHookProc;
					crChatBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crChatBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						cfg.cp.crChat2 = crChatBkg.rgbResult;
						SendMessage(hChat2,EM_SETBKGNDCOLOR,0,
								   (LPARAM)(COLORREF)cfg.cp.crChat2);
					}
					EmptyTheMessageQue();
				}
				break;

				case IDC_BOTTOMPANEL:
				{
					ZeroMemory(&crChatBkg,sizeof(CHOOSECOLOR));
					lpIconPointer = lpszAppName;

					crChatBkg.lStructSize = sizeof(CHOOSECOLOR);
					crChatBkg.hwndOwner = hMainWindow;
					crChatBkg.rgbResult = cfg.cp.crChat3;
					crChatBkg.lpCustColors = (LPDWORD)cfg.crBkgCustom;
					crChatBkg.lpfnHook = MyCCHookProc;
					crChatBkg.Flags = CC_RGBINIT | CC_SHOWHELP | CC_ENABLEHOOK | CC_FULLOPEN;

					// Go and get the color selection.
					//...............................
					if(!ChooseColor(&crChatBkg))
					{
						CommDlgBoxErrorProc(IDS_CHOOSE_COLOR);
					}
					else
					{
						// We have a valid color selection.
						//.................................
						cfg.cp.crChat3 = crChatBkg.rgbResult;
						SendMessage(hChat3,EM_SETBKGNDCOLOR,0,
							       (LPARAM)(COLORREF)cfg.cp.crChat3);
					}
					EmptyTheMessageQue();
				}
				break;

				case IDCANCEL:
				case IDOK:
				{

					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// Set the computers time using NIST time servers over the internet.
//..................................................................
VOID SetTimeFromInternet()
{
	DWORD			dwOldHelpTopic;
	int				iResult;

	bProcessInProgress = TRUE;

	dwOldHelpTopic = ChangeHelpTopic(IDH_INTERNET_TIME);

	iResult = DialogBox(hInst,TEXT("INTERNETTIME"),hMainWindow,(DLGPROC)InternetTimeProc);

	// See if we had a system error in creating the dialog box.
	//.........................................................
	if (iResult == -1)
	{
		ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
	}
	ChangeHelpTopic(dwOldHelpTopic);
	bProcessInProgress = FALSE;
}

// CALLBACK procedure for setting the time from the internet.
//...........................................................
LRESULT CALLBACK InternetTimeProc(HWND hDlg, UINT uiMsg, WPARAM wParam, LPARAM lParam)
{
	ULONG			ulTime;
	WORD			wEvent, wError;
	WSADATA			WSAData;
	int				iError, iSize;
	BOOL			bErr;

	switch(uiMsg)
	{
		case WM_INITDIALOG:
		{
			// Set the designated server to use.
			//..................................
			if (!cfg.cp.iServer)
			{
				cfg.cp.iServer = IDC_SERVER1;
			}
			CheckRadioButton(hDlg,IDC_SERVER1,IDC_SERVER9,cfg.cp.iServer);

			hWndEdit = GetDlgItem(hDlg,IDC_TEXTOUT);
			hButton = GetDlgItem(hDlg,IDC_SET_TIME);

			// We are not setting the time.
			//.............................
			bSettingTime = FALSE;

			// Setup the icon to use in the caption bar.
			//..........................................
			lpIconPointer = lpszAppName;
			SetMyIcon(hDlg);
			CenterWindow(hDlg,GetWindow(hDlg,GW_OWNER));
			return(TRUE);
		}

		case WM_COMMAND:
		{
			switch (LOWORD(wParam))
			{
				case IDC_SERVER1:
				case IDC_SERVER2:
				case IDC_SERVER3:
				case IDC_SERVER4:
				case IDC_SERVER5:
				case IDC_SERVER6:
				case IDC_SERVER7:
				case IDC_SERVER8:
				case IDC_SERVER9:
				{
					cfg.cp.iServer = LOWORD(wParam);
					CheckRadioButton(hDlg,IDC_SERVER1,IDC_SERVER9,cfg.cp.iServer);
				}
				break;

				case IDC_SET_TIME:
				{
					// Dial the internet.
					//...................
					if (cfg.dwDialupNetwork)
					{
						bErr = DialInternet(hDlg);
						if (bErr)
						{
							break;
						}
					}
					// Call "WSAStartup" and display description text.
					//................................................
					if (iError = WSAStartup(MAKEWORD(2,0),&WSAData))
					{
						EditPrintf(hWndEdit,TEXT("Startup error #%i.\r\n\r\n"),iError) ;
						break;
					}
					EditPrintf(hWndEdit,TEXT("Started up %hs\r\n"),WSAData.szDescription);

					// Call the socket.
					//.................
					sock = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
					if (sock == INVALID_SOCKET)
					{
						EditPrintf(hWndEdit,TEXT("Socket creation error #%i.\r\n\r\n"), 
                                   WSAGetLastError());
						WSACleanup();
						break;
					}
					EditPrintf(hWndEdit,TEXT("Socket %i created.\r\n"),sock);

					// Call WSAAsyncSelect.
					//.....................
					if (SOCKET_ERROR == WSAAsyncSelect(sock,hDlg,WM_SOCKET_NOTIFY, 
													   FD_CONNECT | FD_READ))
					{
						EditPrintf(hWndEdit,TEXT("WSAAsyncSelect error #%i.\r\n\r\n"),
								   WSAGetLastError());
						closesocket(sock);
						WSACleanup();
						break;
					}
					// Call connect with IP address and time-server port.
					//...................................................
					sa.sin_family = AF_INET;
					sa.sin_port = htons(IPPORT_TIMESERVER);
					sa.sin_addr.s_addr = inet_addr(lpServers[cfg.cp.iServer - IDC_SERVER1]);

					connect(sock,(SOCKADDR *)&sa,sizeof(sa));

					// "connect" will return SOCKET_ERROR because even if it
                    // succeeds, it will require blocking. The following only
                    // reports unexpected errors.
					//.......................................................
					if (WSAEWOULDBLOCK != (iError = WSAGetLastError()))
					{
						EditPrintf(hWndEdit,TEXT("Connect error #%i.\r\n\r\n"),iError);
						closesocket(sock);
						WSACleanup();
						sock = 0;
						break;
					}
					EditPrintf(hWndEdit,TEXT("Connecting to %hs..."),
							   lpServers[cfg.cp.iServer - IDC_SERVER1]);
     
                    // The result of the "connect" call will be reported 
                    // through the WM_SOCKET_NOTIFY message.
                    // Set timer and change the button to "Cancel"
					//..................................................
					SetTimer(hDlg,MY_TIMER,1000,NULL);
					SetWindowText(hButton,TEXT("&Cancel"));
					SetWindowLong(hButton,GWL_ID,IDC_TIME_CANCEL);
					EnableWindow(GetDlgItem(hDlg,IDOK),FALSE);
					bSettingTime = TRUE;
				}
				break;

				case IDC_TIME_CANCEL:
				{
					closesocket(sock);
					sock = 0;
					WSACleanup();
					SetWindowText(hButton,TEXT("&Set Correct Time"));
					SetWindowLong(hButton,GWL_ID,IDC_SET_TIME);
					KillTimer(hDlg,MY_TIMER);
					EditPrintf(hWndEdit,TEXT("\r\nSocket closed.\r\n\r\n"));
					EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
					bSettingTime = FALSE;
				}
				break;

				case IDCANCEL:
				case IDOK:
				{
					if (bSettingTime)
					{
						closesocket(sock);
						sock = 0;
						WSACleanup();
						SetWindowText(hButton,TEXT("&Set Correct Time"));
						SetWindowLong(hButton,GWL_ID,IDC_SET_TIME);
						KillTimer(hDlg,MY_TIMER);
						EditPrintf(hWndEdit,TEXT("\r\nSocket closed.\r\n\r\n"));
						EnableWindow(GetDlgItem(hDlg,IDOK),TRUE);
						bSettingTime = FALSE;
					}

					if (!bFromChat)
					{
						HangUp(hDlg);
						EmptyTheMessageQue();
						ZeroMemory(&szIPAddress,sizeof(szIPAddress));
						lpIPAddress = 0;
					}
					EndDialog(hDlg,IDOK);
				}
				break;

				case IDC_MYHELP:
				{
					DisplayMyHelp(hDlg);
				}
				break;
			}
		}
		break;

		case WM_TIMER:
		{
			EditPrintf(hWndEdit,TEXT ("."));
		}
		break;

		case WM_SOCKET_NOTIFY:
		{
			wEvent = WSAGETSELECTEVENT(lParam);   // ie, LOWORD
			wError = WSAGETSELECTERROR(lParam);   // ie, HIWORD

            // Process two events specified in WSAAsyncSelect.
			//................................................
			switch (wEvent)
			{
				// This event occurs as a result of the "connect" call.
				//.....................................................
				case FD_CONNECT:
				{
					EditPrintf(hWndEdit,TEXT("\r\n"));

					if (wError)
					{
						EditPrintf(hWndEdit,TEXT("Connect error #%i."),wError);
						SendMessage(hDlg,WM_COMMAND,IDC_TIME_CANCEL,0);
						break;
					}
					EditPrintf(hWndEdit,TEXT("Connected to %hs.\r\n"),
							   lpServers[cfg.cp.iServer - IDC_SERVER1]);

					// Try to receive data. The call will generate an error
					// of WSAEWOULDBLOCK and an event of FD_READ.
					//.....................................................
					recv(sock,(char *)&ulTime,4,MSG_PEEK);
					EditPrintf(hWndEdit,TEXT("Waiting to receive..."));
				}
				break;

				// This even occurs when the "recv" call can be made.
				//...................................................               
				case FD_READ:
				{
					KillTimer(hDlg,MY_TIMER);
					EditPrintf(hWndEdit,TEXT("\r\n"));

					if (wError)
					{
						EditPrintf(hWndEdit,TEXT("FD_READ error #%i."),wError);
						SendMessage(hDlg,WM_COMMAND,IDC_TIME_CANCEL,0);
						break;
					}
					// Get the time and swap the bytes.
					//.................................
					iSize = recv(sock,(char *)&ulTime,4,0);
					ulTime = ntohl(ulTime);
					EditPrintf(hWndEdit,TEXT("Received current time of %u seconds ")
							   TEXT("since Jan. 1 1900.\r\n"),ulTime);

					// Change the system time.
					//........................
					ChangeSystemTime(hDlg,hWndEdit,ulTime);
					SendMessage(hDlg,WM_COMMAND,IDC_TIME_CANCEL,0);
				}
				break;
			}
		}
		break;
			
		case WM_HELP:
		{
			PopupHelp(hDlg,lParam);
		}
		break;

		case WM_CONTEXTMENU:
		{
			WhatsThis(hDlg,(HWND)wParam,lParam);
		}
		break;

		default:
			return(FALSE);
	}
	return(TRUE);
}

// We are online second edition.
//..............................
BOOL WeAreOnline(BOOL bShowDialog)
{
	BOOL		bOnline = FALSE;
	int			iError, i;
	LPBYTE		lpIpAddress;
	DWORD		dwTime;
	WSADATA		WSAData;
	int			iNameLength;
	struct sockaddr_in	sachk;
	BOOL		bResult;
	DWORD		dwStatus;
	SOCKET		sockchk = 0;

	bResult = InternetGetConnectedState(&dwStatus,0);

	if (bResult && (dwStatus & INTERNET_CONNECTION_LAN))
	{
		if (iError = WSAStartup(MAKEWORD(2,0),&WSAData))
		{
			goto OnlineEnd;
		}
		sockchk = socket(AF_INET,SOCK_STREAM,IPPROTO_IP);
		if (sockchk == INVALID_SOCKET)
		{
			WSACleanup();
			goto OnlineEnd;
		}
		if (bShowDialog)
		{
			// Display the trying internet connection dialog box.
			//...................................................
			hDlgCurrent = CreateDialog(hInst,TEXT("LANTRYINTERNET"),hMainWindow,
									  (DLGPROC)CenterDlgBoxProc);

			if (!hDlgCurrent)
			{
				ErrorProcedure(lpszNA,IDS_CREATEDIALOGBOX,MB_OK);
				goto OnlineEnd;
			}
		}
		// Connect to an actual IP address.
		//.................................
		for (i = iTimeServer; i < 9; i++)
		{
			sachk.sin_family = AF_INET;
			sachk.sin_port = htons(IPPORT_TIMESERVER);
			sachk.sin_addr.s_addr = inet_addr(lpServers[i]);

			iError = connect(sockchk,(SOCKADDR *)&sachk,sizeof(sachk));

			if (!iError)
			{
				if (!bIPAddress)
				{
					recv(sockchk,(char *)&dwTime,4,0);

					// Get our IP address.
					//....................
					iNameLength = sizeof(sachk);
					getsockname(sockchk,(SOCKADDR *)&sachk,&iNameLength);
					lpIpAddress = inet_ntoa(sachk.sin_addr);
					CopyMemory(&szIPAddress,lpIpAddress,sizeof(szIPAddress));
					bIPAddress = TRUE;

					// If we have a permanent IP address get it.
					//..........................................
					if (lstrlen((LPCTSTR)&cfg.szPermanentIP) > 0)
					{
						CopyMemory(&szIPAddress,&cfg.szPermanentIP,sizeof(cfg.szPermanentIP));
					}
				}
				bOnline = TRUE;
				iTimeServer = i;
				break;
			}
			else
			{
				// We had an error. What is it.
				//.............................
				iError = WSAGetLastError();
				if (iError != WSAETIMEDOUT && iError != WSAECONNREFUSED)
				{
					break;
				}
			}
		}
		closesocket(sockchk);
		WSACleanup();

		if (bShowDialog)
		{
			// Destroy the modless dialog box.
			//................................
			DestroyWindow(hDlgCurrent);
			hDlgCurrent = 0;
		}
	}
	OnlineEnd:

	return(bOnline);
}

// Check to see if we are online or not.
//......................................
BOOL WeAreOnline2()
{
	BOOL				bOnline = FALSE;
	LPRASCONN			lpRasConn = 0;
	DWORD				dwResult = 0;
	DWORD				dwBytes = 0;
	DWORD				dwConnections = 0;
	RASPPPIP			rasip;

	// If we already have a connection just return with bOnline = TRUE.
	//.................................................................
	lpRasConn = AllocateMemory(sizeof(RASCONN));
	if (!lpRasConn)
	{
		goto CheckEnd;
	}
	lpRasConn->dwSize = sizeof(RASCONN);
	dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
	if (dwResult == ERROR_BUFFER_TOO_SMALL)
	{
		DeallocateMemory(lpRasConn);
		lpRasConn = 0;
		lpRasConn = AllocateMemory(dwBytes);
		if (!lpRasConn)
		{
			goto CheckEnd;
		}
		lpRasConn->dwSize = sizeof(RASCONN);
		dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
	}
	if (dwResult)
	{
		RasError(dwResult);
		goto CheckEnd;
	}
	if (dwConnections >= 1)
	{
		bOnline = TRUE;

		lpRasConn->dwSize = sizeof(RASCONN);
		dwBytes = sizeof(RASCONN);
		dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);

		if (!dwResult)
		{
			rasip.dwSize = sizeof(rasip);
			dwResult = RasGetProjectionInfo(lpRasConn->hrasconn,RASP_PppIp,&rasip,
											&rasip.dwSize);
			if (!dwResult)
			{
				ZeroMemory(&szIPAddress,sizeof(szIPAddress));
				CopyMemory(&szIPAddress,&rasip.szIpAddress,RAS_MaxIpAddress + 1);
				bIPAddress = TRUE;
			}
			else
			{
				bIPAddress = FALSE;
			}
		}
	}

	CheckEnd:

	return(bOnline);
}

// Dial an internet connection.
//.............................
BOOL DialInternet(HWND hWnd)
{
	BOOL				bErr = TRUE;
	LPRASCONN			lpRasConn = 0;
	LPRASENTRYNAME		lpRasEntry = 0;
	DWORD				dwBytes = 0;
	DWORD				dwConnections = 0;
	DWORD				dwResult = 0;
	RASPPPIP			rasip;

	// If we already have a connection just return with no error.
	//...........................................................
	lpRasConn = AllocateMemory(sizeof(RASCONN));
	if (!lpRasConn)
	{
		goto DialEnd;
	}
	lpRasConn->dwSize = sizeof(RASCONN);
	dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
	if (dwResult == ERROR_BUFFER_TOO_SMALL)
	{
		DeallocateMemory(lpRasConn);
		lpRasConn = 0;
		lpRasConn = AllocateMemory(dwBytes);
		if (!lpRasConn)
		{
			goto DialEnd;
		}
		lpRasConn->dwSize = sizeof(RASCONN);
		dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
	}
	if (dwResult)
	{
		RasError(dwResult);
		goto DialEnd;
	}
	if (dwConnections >= 1)
	{
		bErr = FALSE;
		goto DialEnd;
	}
	// Get our entry names to dial.
	//.............................
	lpRasEntry = AllocateMemory(sizeof(RASENTRYNAME));
	if (!lpRasEntry)
	{
		goto DialEnd;
	}
	lpRasEntry->dwSize = sizeof(RASENTRYNAME);
	dwBytes = 0;
	dwConnections = 0;
	dwResult = RasEnumEntries(NULL,NULL,lpRasEntry,&dwBytes,&dwConnections);
	if (dwResult == ERROR_BUFFER_TOO_SMALL)
	{
		DeallocateMemory(lpRasEntry);
		lpRasEntry = AllocateMemory(dwBytes);
		if (!lpRasEntry)
		{
			goto DialEnd;
		}
		lpRasEntry->dwSize = sizeof(RASENTRYNAME);
	}
	dwResult = RasEnumEntries(NULL,NULL,lpRasEntry,&dwBytes,&dwConnections);
	if (dwResult != ERROR_SUCCESS)
	{
		RasError(dwResult);
		goto DialEnd;
	}
	dwResult = InternetDial(hWnd,lpRasEntry->szEntryName,INTERNET_DIAL_FORCE_PROMPT,
							&dwConnection,0);
	if (dwResult == ERROR_SUCCESS)
	{
		bErr = FALSE;
		bWeDialedInternet = TRUE;
	}

	DialEnd:

	if (!bErr)
	{
		lpRasConn->dwSize = sizeof(RASCONN);
		dwBytes = sizeof(RASCONN);
		dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);

		if (!dwResult)
		{
			rasip.dwSize = sizeof(rasip);
			dwResult = RasGetProjectionInfo(lpRasConn->hrasconn,RASP_PppIp,&rasip,
											&rasip.dwSize);
			if (!dwResult)
			{
				ZeroMemory(&szIPAddress,sizeof(szIPAddress));
				CopyMemory(&szIPAddress,&rasip.szIpAddress,RAS_MaxIpAddress + 1);
				bIPAddress = TRUE;
			}
			else
			{
				bIPAddress = FALSE;
			}
		}
	}
	if (lpRasEntry)
	{
		DeallocateMemory(lpRasEntry);
	}
	if (lpRasConn)
	{
		DeallocateMemory(lpRasConn);
	}
	return(bErr);
}

// Display an RAS error message box.
//..................................
VOID RasError(DWORD dwErr)
{
	TCHAR		szBuffer1[256];
	TCHAR		szBuffer2[256];

	LoadString(hInst,IDS_RAS_ERROR,szBuffer1,sizeof(szBuffer1));
	StringCbPrintf((LPTSTR)&szBuffer2,sizeof(szBuffer2),(LPCTSTR)&szBuffer1,dwErr);
	MessageBoxProc(hMainWindow,IDS_ADVISORY,(UINT)&szBuffer2,
				   MB_OK | MB_ICONINFORMATION | MB_HELP,MB_ICONINFORMATION,0);
}

// Hangup the phone.
//..................
BOOL HangUp(HWND hWnd)
{
	LPRASCONN		lpRasConn = 0;
	RASCONNSTATUS	rasconnstatus;
	DWORD			dwBytes = 0;
	DWORD			dwConnections = 0;
	DWORD			dwResult = 0;
	int				iResult;
	BOOL			bWeHungup = FALSE;

	// If we did not dial the internet, break out.
	//............................................
	if (!bWeDialedInternet)
	{
		goto HangupEnd;
	}
	// If we have one connection ask if we want to hangup.
	//....................................................
	lpRasConn = AllocateMemory(sizeof(RASCONN));
	if (!lpRasConn)
	{
		goto HangupEnd;
	}
	lpRasConn->dwSize = sizeof(RASCONN);
	dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
	if (dwResult == ERROR_BUFFER_TOO_SMALL)
	{
		DeallocateMemory(lpRasConn);
		lpRasConn = 0;
		lpRasConn = AllocateMemory(dwBytes);
		if (!lpRasConn)
		{
			goto HangupEnd;
		}
		lpRasConn->dwSize = sizeof(RASCONN);
		dwResult = RasEnumConnections(lpRasConn,&dwBytes,&dwConnections);
		if (dwResult == 0 && dwConnections == 1)
		{
			// Ask if we want to hangup the phone.
			//....................................
			iResult = MessageBoxProc(hMainWindow,IDS_QUESTION,IDS_HANGUP,
									 MB_YESNO | MB_ICONQUESTION | MB_HELP,
									 MB_ICONQUESTION,0);	
			if (iResult == IDNO)
			{
				goto HangupEnd;
			}
			// We can hangup.
			//...............
			dwResult = RasHangUp(lpRasConn->hrasconn);
			if (dwResult == 0)
			{	
				rasconnstatus.dwSize = sizeof(RASCONNSTATUS);
				while(TRUE)
				{
					dwResult = RasGetConnectStatus(lpRasConn->hrasconn,&rasconnstatus);
					Sleep(0);
					if (dwResult == ERROR_INVALID_HANDLE)
					{
						break;
					}
				}
				bWeHungup = TRUE;
			}
			else
			{
				RasError(dwResult);
			}
		}
		else if (dwResult)
		{
			RasError(dwResult);
		}
	}
	else if (dwResult == 0 && dwConnections == 0)
	{
		// We have alread hungup.
		//.......................
		bWeHungup = TRUE;
	}
	// We hung up the phone. Delete our IP address.
	//.............................................
	if (bWeHungup)
	{
		lpIPAddress = 0;
		bIPAddress = FALSE;
		ZeroMemory(&szIPAddress,sizeof(szIPAddress));
		ZeroMemory(&szClientIP,sizeof(szClientIP));
	}
	HangupEnd:

	if (lpRasConn)
	{
		DeallocateMemory(lpRasConn);
	}
	EmptyTheMessageQue();

	return(bWeHungup);
}

// Change the system time.
//........................
VOID ChangeSystemTime(HWND hDlg, HWND hWndEdit, ULONG ulTime)
{
	char                  szTimeZone[32], szBuffer [1000];
    DWORD                 dwTickCount;
    FILETIME              ftSysNew, ftLocOld, ftLocNew;
    int                   i, iReturn;
    LARGE_INTEGER         liSysNew, liLocOld, liLocNew, liDiff;
    SYSTEMTIME            stSysNew, stLocOld, stLocNew;
    TIME_ZONE_INFORMATION tzi;

    // Get the local time and convert it to a LARGE_INTEGER.
	//......................................................
    GetLocalTime(&stLocOld);
    SystemTimeToFileTime(&stLocOld,&ftLocOld);
    liLocOld = *(LARGE_INTEGER *)&ftLocOld;

    // Calculate the new system time.
	//...............................
    stSysNew.wYear         = 1900;
    stSysNew.wMonth        = 1;
    stSysNew.wDay          = 1;
    stSysNew.wHour         = 0;
    stSysNew.wMinute       = 0;
    stSysNew.wSecond       = 0;
    stSysNew.wMilliseconds = 0;

    SystemTimeToFileTime(&stSysNew,&ftSysNew);
    liSysNew = *(LARGE_INTEGER *)&ftSysNew;
    liSysNew.QuadPart += (LONGLONG)10000000 * ulTime; 
    ftSysNew = *(FILETIME *)&liSysNew;
    FileTimeToSystemTime(&ftSysNew,&stSysNew);

    // Convert that new system time to a local time.
	//..............................................
    GetTimeZoneInformation(&tzi);
    MySystemTimeToTzSpecificLocalTime(&tzi,&stSysNew,&stLocNew);

    // Convert the new local time to a LARGE_INTEGER.
	//...............................................
    SystemTimeToFileTime(&stLocNew,&ftLocNew);
    liLocNew = *(LARGE_INTEGER *)&ftLocNew;

    // Compare the existing local time with the new local time
    // (No abs function for large integers!)
	//........................................................
    liDiff.QuadPart = liLocNew.QuadPart - liLocOld.QuadPart;

    if (liDiff.QuadPart < 0)
	{
		liDiff.QuadPart = -liDiff.QuadPart;
	}
    // Check if we're going to change the time by more than 15 minutes!
	//.................................................................
    if (liDiff.QuadPart > 15 * 60 * (__int64) 10000000)
    {
		// This might take some time, so get the tick count first
		//.......................................................
        dwTickCount = GetTickCount();

        for (i = 0; szTimeZone[i] = (char)tzi.StandardName[i]; i++);
                               
        StringCbPrintf(szBuffer,sizeof(szBuffer),
					   "WARNING: It appears as if your computer time "
                       "is incorrect by about %i minutes. You may be "
                       "well aware of this, in which case just press "
                       "the 'OK' button and the time will be corrected.",
					   (int)(liDiff.QuadPart / 60 / (__int64)10000000),szTimeZone);

        iReturn = MessageBoxProc(hDlg,IDS_QUESTION,(UINT)&szBuffer,
								 MB_OKCANCEL | MB_ICONQUESTION | MB_HELP,
								 MB_ICONQUESTION,0);

        if (iReturn == IDCANCEL)
        {
			EditPrintf(hWndEdit,"Did NOT set new date and time.");
            return;
        }
        // This is the number of milliseconds that has elapsed since the 
        // correct time was retrieved.
		//..............................................................
        dwTickCount = GetTickCount() - dwTickCount;
        liSysNew.QuadPart += 10000 * dwTickCount;

        EditPrintf(hWndEdit,"Time adjusted by %i.%3i seconds elapsed "
                            "since message box was displayed.\r\n", 
							 dwTickCount / 1000,dwTickCount % 1000);
	}
    ftSysNew = *(FILETIME *)&liSysNew;
    FileTimeToSystemTime(&ftSysNew,&stSysNew);

    GetLocalTime(&stLocOld);

    if (SetSystemTime(&stSysNew))
    {
		GetLocalTime(&stLocNew);
        FormatUpdatedTime(hWndEdit,&stLocOld,&stLocNew);
		if (!bWin2000OrGreater)
		{
			SendNotifyMessage(HWND_BROADCAST,WM_TIMECHANGE,0,0);
		}
    }
    else
	{
		EditPrintf(hWndEdit,"Could NOT set new date and time.\r\n");
	}
}

// FormatUpdatedTime.
//...................
VOID FormatUpdatedTime(HWND hwndEdit, LPSYSTEMTIME pstOld, LPSYSTEMTIME pstNew)
{
	TCHAR	szDateOld [64], szTimeOld [64], szDateNew [64], szTimeNew [64];

    GetDateFormat(LOCALE_USER_DEFAULT,0,pstOld,TEXT("ddd',' MMM dd yyyy"),szDateOld,
				  sizeof(szDateOld));
     
    GetTimeFormat(LOCALE_USER_DEFAULT,LOCALE_NOUSEROVERRIDE | 
                  TIME_NOTIMEMARKER | TIME_FORCE24HOURFORMAT,
                  pstOld,NULL,szTimeOld,sizeof(szTimeOld));

    GetDateFormat(LOCALE_USER_DEFAULT,0,pstNew,TEXT("ddd',' MMM dd yyyy"),szDateNew,
				  sizeof(szDateNew));
     
    GetTimeFormat(LOCALE_USER_DEFAULT,LOCALE_NOUSEROVERRIDE | 
                  TIME_NOTIMEMARKER | TIME_FORCE24HOURFORMAT,
                  pstNew,NULL,szTimeNew,sizeof(szTimeNew));

    EditPrintf(hWndEdit,"Local date and time successfully changed "
               "from\r\n\t%s, %s.%03i to\r\n\t%s, %s.%03i.", 
               szDateOld,szTimeOld,pstOld->wMilliseconds,
               szDateNew, szTimeNew,pstNew->wMilliseconds);
}

// EditPrintf: A printf function for edit boxes!
//..............................................
VOID EditPrintf (HWND hwndEdit, TCHAR * szFormat, ...)
{
    TCHAR		szBuffer[1024];
    va_list		pArgList;

    va_start(pArgList,szFormat);
	StringCbVPrintf(szBuffer,sizeof(szBuffer),szFormat,pArgList);
    va_end(pArgList);

	if (hwndEdit == hChat3)
	{
		SetFocus(hwndEdit);
	}
    SendMessage(hwndEdit,EM_SETSEL,(WPARAM)-1,(LPARAM)-1);
	SendMessage(hwndEdit,EM_REPLACESEL,FALSE,(LPARAM)szBuffer);
	SendMessage(hwndEdit,EM_SCROLL,SB_PAGEDOWN,0);

	if (bSendFocus)
	{
		SetFocus(hChat2);
	}
}

// MySystemTimeToTzSpecificLocalTime. Works on all platforms.
// UTC time and time-zone information go in; local time comes out.
//................................................................
BOOL MySystemTimeToTzSpecificLocalTime(LPTIME_ZONE_INFORMATION ptzi, 
                                       LPSYSTEMTIME pstUtc, LPSYSTEMTIME pstLoc)
{
	FILETIME			ft;
    LARGE_INTEGER		li;
	SYSTEMTIME			stDst;

    // If we're running under NT, just call the real function.
	//........................................................
    if (bIsWinNT)
	{
		return(SystemTimeToTzSpecificLocalTime(ptzi,pstUtc,pstLoc));
	}
    // Convert time to a LARGE_INTEGER and subtract the bias.
	//.......................................................
    SystemTimeToFileTime(pstUtc,&ft);
    li = *(LARGE_INTEGER *)&ft;
    li.QuadPart -= (LONGLONG)600000000 * ptzi->Bias;

    // Convert to a local date/time before application of daylight saving time.
    // The local date/time must be used to determine when the conversion occurs.
	//..........................................................................
    ft = *(FILETIME *)&li;
    FileTimeToSystemTime(&ft, pstLoc);

    // Find the time assuming Daylight Saving Time.
	//.............................................
    li.QuadPart -= (LONGLONG)600000000 * ptzi->DaylightBias;
    ft = *(FILETIME *)&li;
    FileTimeToSystemTime(&ft,&stDst);

    // Now put li back the way it was.
	//................................
    li.QuadPart += (LONGLONG)600000000 * ptzi->DaylightBias;

    if (ptzi->StandardDate.wMonth)          // ie, daylight savings time
    {
		// Northern hemisphere.
		//.....................
        if ((ptzi->DaylightDate.wMonth < ptzi->StandardDate.wMonth) &&
            (stDst.wMonth >= pstLoc->wMonth) &&           // avoid the end of year problem
             LocalGreaterThanTransition(pstLoc,&ptzi->DaylightDate) &&
             !LocalGreaterThanTransition(&stDst,&ptzi->StandardDate))
		{
			li.QuadPart -= (LONGLONG) 600000000 * ptzi->DaylightBias;
		}
        // Southern hemisphere.
		//.....................
        else if ((ptzi->StandardDate.wMonth < ptzi->DaylightDate.wMonth) &&
                 (!LocalGreaterThanTransition (&stDst,&ptzi->StandardDate) ||
                  LocalGreaterThanTransition (pstLoc,&ptzi->DaylightDate)))
		{
			li.QuadPart -= (LONGLONG)600000000 * ptzi->DaylightBias;
        }
        else
        {
			li.QuadPart -= (LONGLONG)600000000 * ptzi->StandardBias;
        }
     }

     ft = *(FILETIME *)&li;
     FileTimeToSystemTime(&ft,pstLoc);
     return(TRUE);
}

// LocalGreaterThanTransition: Returns TRUE if the local time comes 
// after the daylight saving time (or standard time) transition.
//.................................................................
BOOL LocalGreaterThanTransition(LPSYSTEMTIME pstLoc, LPSYSTEMTIME pstTran)
{
	FILETIME		ftLoc, ftTran ;
    LARGE_INTEGER	liLoc, liTran ;
    SYSTEMTIME		stTranAbs ;

    // Easy case: Just compare the two months.
	//........................................
    if (pstLoc->wMonth != pstTran->wMonth)
	{
		return(pstLoc->wMonth > pstTran->wMonth);
	}
    // Well, we're in a transition month. That requires a bit more work.
    // Check if pstDst is in absolute or day-in-month format.
    // (See documentation of TIME_ZONE_INFORMATION, StandardDate field.)
	//..................................................................
    if (pstTran->wYear)       // absolute format (haven't seen one yet!)
    {
		stTranAbs = *pstTran;
    }
    else                     // day-in-month format
    {
		ConvertToAbsolute(pstLoc,pstTran,&stTranAbs);
    }
    // Now convert both date/time structures to large integers & compare.
    //................................................................... 
    SystemTimeToFileTime(pstLoc,&ftLoc);
    liLoc = *(LARGE_INTEGER *)&ftLoc;

    SystemTimeToFileTime(&stTranAbs,&ftTran);
    liTran = *(LARGE_INTEGER *)&ftTran;

    return(liLoc.QuadPart > liTran.QuadPart);
}

// ConvertToAbsolute:  Converts day-in-month format to absolute date/time.
//........................................................................
VOID ConvertToAbsolute(LPSYSTEMTIME pstLoc, LPSYSTEMTIME pstDst, LPSYSTEMTIME pstDstAbs)
{
    static int    iDays [12] = {31, 28, 31, 30, 31, 30, 
                                31, 31, 30, 31, 30, 31};
    int           iDay;

	// Set up the absolute date structure except for wDay, which we must find.
	//........................................................................
    pstDstAbs->wYear         = pstLoc->wYear;      // Notice from local date/time
    pstDstAbs->wMonth        = pstDst->wMonth;
    pstDstAbs->wDayOfWeek    = pstDst->wDayOfWeek;

    pstDstAbs->wHour         = pstDst->wHour;
    pstDstAbs->wMinute       = pstDst->wMinute;
    pstDstAbs->wSecond       = pstDst->wSecond;
    pstDstAbs->wMilliseconds = pstDst->wMilliseconds;

    // Fix the iDays array for leap years.
	//....................................
    if ((pstLoc->wYear % 4 == 0) && ((pstLoc->wYear % 100 != 0) || (pstLoc->wYear % 400 == 0)))
    {
		iDays[1] = 29;
    }
    // Find a day of the month that falls on the same 
    // day of the week as the transition.

    // Suppose today is the 20th of the month (pstLoc->wDay = 20)
    // Suppose today is a Wednesday (pstLoc->wDayOfWeek = 3)
    // Suppose the transition occurs on a Friday (pstDst->wDayOfWeek = 5)
    // Then iDay = 31, meaning that the 31st falls on a Friday
    // (The 7 in this formula avoids negatives.
	//...................................................................
    iDay = pstLoc->wDay + pstDst->wDayOfWeek + 7 - pstLoc->wDayOfWeek;

    // Now shrink iDay to a value between 1 and 7.
	//............................................
    iDay = (iDay - 1) % 7 + 1;

    // Now iDay is a day of the month ranging from 1 to 7.
    // Recall that the wDay field of the structure can range
    // from 1 to 5, 1 meaning "first", 2 meaning "second",
    // and 5 meaning "last".
    // So, increase iDay so it's the proper day of the month.
	//.......................................................
    iDay += 7 * (pstDst->wDay - 1);

    // Could be that iDay overshot the end of the month, so
    //   fix it up using the number of days in each month.
	//.....................................................
    if (iDay > iDays[pstDst->wMonth - 1])
	{
		iDay -= 7;
	}
    // Assign that day to the structure.
	//..................................
    pstDstAbs->wDay = iDay;
}

// Save a chat session in a rtf box as a file.
//............................................
VOID SaveChatAs(HWND hDlg, int iIDRtf)
{
	OPENFILENAME		ofn;
	BOOL				bResult;
	TCHAR				szBuffer[512];

	// Initialize the OPENFILENAME structure.
	//.......................................
	InitializeOFN(&ofn,SAVE_DESTINATION);

	// Initialize with specific information for our packed file.
	//..........................................................
	ofn.lpstrFile = szFileToEncipher;
	ofn.nMaxFile = MAX_PATH;
	ofn.hwndOwner = hMainWindow;
	ofn.lpstrFilter = TEXT("Rich Text File [*.rtf]\0*.rtf\0All Files [*.*]\0*.*\0");
	ofn.nFilterIndex = 1;
	ofn.Flags = (OFN_EXPLORER | OFN_PATHMUSTEXIST | OFN_NONETWORKBUTTON | 
				 OFN_ENABLEHOOK | OFN_ENABLESIZING | OFN_SHOWHELP | OFN_OVERWRITEPROMPT |
				 OFN_HIDEREADONLY);
	ofn.lpstrTitle = TEXT("Save Chat Session As Rich Text File");
	ofn.lpstrDefExt = TEXT("rtf");
	ofn.lpfnHook = MyOFNHookProc;

	// Get a destination and file name to save the packed file to.
	//............................................................
	ZeroMemory(&szFileToEncipher,MAX_PATH);

	// Get the name and path we want to use for our packed file.
	//..........................................................
	if (!GetSaveFileName(&ofn))
	{
		CommDlgBoxErrorProc(IDS_SAVE_AS);
		return;
	}
	SaveDirName((LPBYTE)&szFileToEncipher,SAVE_DESTINATION,TRUE);

	EmptyTheMessageQue();

	// Create the file.
	//.................
	bResult = CreateFileStreamOut((LPTSTR)&szFileToEncipher,hDlg,iIDRtf,SF_RTF,FALSE);
	if (bResult)
	{
		StringCbPrintf((LPTSTR)&szBuffer,sizeof(szBuffer),(LPCTSTR)&szChatSaveAs,
						&szFileToEncipher);
		MessageBoxProc(hDlg,IDS_ADVISORY,(UINT)&szBuffer,MB_ICONINFORMATION | MB_OK,
					   MB_ICONINFORMATION,0);
	}
	EmptyTheMessageQue();
}

// Select a character font for the send or receive text in a chat rtf box.
//........................................................................
VOID SelectCharFormatChat(HWND hDlg, HWND hControl)
{
	LOGFONT			lfSend;
	CHOOSEFONT		csfSend;
	CHARFORMAT2		cfSend;
	LONG			yPerInchSend;
	HDC				hdcSend;
	CHARRANGE		crSend;

	ZeroMemory(&cfSend,sizeof(CHARFORMAT2));
	ZeroMemory(&lfSend,sizeof(LOGFONT));
	ZeroMemory(&csfSend,sizeof(CHOOSEFONT));

	cfSend.cbSize = sizeof(CHARFORMAT2);

	hdcSend = GetDC(hControl);
	yPerInchSend = GetDeviceCaps(hdcSend,LOGPIXELSY);
	ReleaseDC(hControl,hdcSend);

	lpIconPointer = lpszAppName;

	// Get the current font information from the rich edit control.
	//.............................................................
	SendMessage(hControl,EM_GETCHARFORMAT,(WPARAM)TRUE,(LPARAM)&cfSend);

	// Setup the choose font structure.
	//.................................
	csfSend.lStructSize = sizeof(CHOOSEFONT);
	csfSend.hwndOwner = hDlg;
	csfSend.hDC = 0;
	csfSend.lpLogFont = &lfSend;
	csfSend.Flags = CF_EFFECTS | CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT | CF_SHOWHELP | CF_ENABLEHOOK;
	csfSend.rgbColors = cfg.cp.cfSend.crTextColor;
	csfSend.lpszStyle = NULL;
	csfSend.nFontType = REGULAR_FONTTYPE | SCREEN_FONTTYPE;
	csfSend.lpfnHook = MyCFHookProc;

	// Setup the log font structure.
	//..............................
	lfSend.lfHeight = -(INT) ((cfSend.yHeight * yPerInchSend) / 1440);
	lfSend.lfWidth = 0;
	lfSend.lfEscapement = 0;
	lfSend.lfOrientation = 0;
	lfSend.lfWeight = (cfSend.dwEffects & CFE_BOLD) ? FW_BOLD : FW_NORMAL;
	lfSend.lfItalic = (cfSend.dwEffects & CFE_ITALIC) ? TRUE : FALSE;
	lfSend.lfUnderline = (cfSend.dwEffects & CFE_UNDERLINE) ? TRUE : FALSE;
	lfSend.lfStrikeOut = (cfSend.dwEffects & CFE_STRIKEOUT) ? TRUE : FALSE;
	lfSend.lfOutPrecision = OUT_DEFAULT_PRECIS;
	lfSend.lfClipPrecision = CLIP_DEFAULT_PRECIS;
	lfSend.lfQuality = DRAFT_QUALITY;
	lfSend.lfCharSet = cfSend.bCharSet;
	lfSend.lfPitchAndFamily = cfSend.bPitchAndFamily;
	StringCbCopyEx(lfSend.lfFaceName,LF_FACESIZE,cfSend.szFaceName,NULL,NULL,
				   dwStringSafeFlag);

	// Go and get the font selection.
	//...............................
	if(!ChooseFont(&csfSend))
	{
		CommDlgBoxErrorProc(IDS_FONTS);
	}
	else
	{
		cfSend.cbSize = sizeof(CHARFORMAT2);

		// Don't change read-only bit.
		//............................
		cfSend.dwMask = CFM_SIZE | CFM_BOLD | CFM_ITALIC | CFM_STRIKEOUT | 
			        CFM_UNDERLINE | CFM_COLOR | CFM_FACE | CFM_CHARSET;
		cfSend.yHeight = (LONG) csfSend.iPointSize * 2;
		cfSend.dwEffects = CFE_BOLD | CFE_ITALIC | CFE_STRIKEOUT | CFE_UNDERLINE;
		if(lfSend.lfWeight < FW_BOLD)
		{
			cfSend.dwEffects &= ~CFE_BOLD;
		}
		if(!lfSend.lfItalic)
		{
			cfSend.dwEffects &= ~CFE_ITALIC;
		}
		if(!lfSend.lfUnderline)
		{
			cfSend.dwEffects &= ~CFE_UNDERLINE;
		}
		if(!lfSend.lfStrikeOut)
		{
			cfSend.dwEffects &= ~CFE_STRIKEOUT;
		}
		cfSend.crTextColor = csfSend.rgbColors;
		cfSend.bCharSet = lfSend.lfCharSet;
		cfSend.bPitchAndFamily = lfSend.lfPitchAndFamily;
		StringCbCopyEx(cfSend.szFaceName,LF_FACESIZE,lfSend.lfFaceName,
					   NULL,NULL,dwStringSafeFlag);

		// We only set the font for sending at this point.
		//................................................
		SendMessage(hChat2,EM_SETCHARFORMAT,SCF_SELECTION,(LPARAM)&cfSend);
			
		SendMessage(hChat2,EM_EXGETSEL,0,(LPARAM)&crSend);

		if (crSend.cpMax == crSend.cpMin)
		{
			// Save the new settings.
			//.......................
			CopyMemory(&cfg.cp.cfSend,&cfSend,sizeof(CHARFORMAT2));
		}	
		if (bNoSendClr)
		{
			bNoSendClr = FALSE;
			EnableWindow(GetDlgItem(hDlg,IDC_SENDTXTCLR),TRUE);
		}
	}
}

// Callback functions to stream data out of rich text window to a buffer in memory.
//.................................................................................
DWORD CALLBACK EditStreamPageOutCallback(DWORD dwCookie, LPBYTE pbBuff, LONG cb, LONG FAR *pcb)
{
	// dwCookie equals the maximum size of the buffer to copy data to.
	//................................................................
	if ((dwPageCount + cb) > dwCookie)
	{
		return(1);
	}
	CopyMemory(lpOutBuffer,pbBuff,cb);

	dwPageCount += cb;
	lpOutBuffer += cb;
	*pcb = cb;

	return(0);
}

// Setup the nickname.
//....................
VOID SetupNickName()
{
	ZeroMemory(&szNickName,sizeof(szNickName));
	ZeroMemory(&MyKey.szClientName,sizeof(MyKey.szClientName));
	StringCbCat((LPTSTR)&szNickName,sizeof(szNickName),TEXT("[ "));
	StringCbCat((LPTSTR)&szNickName,sizeof(szNickName),(LPCTSTR)&cfg.cp.szNickName);
	StringCbCat((LPTSTR)&szNickName,sizeof(szNickName),TEXT(" ] "));
	CopyMemory(&MyKey.szClientName,&szNickName,sizeof(szNickName));
}

// Get the user id of the chat key. Returns TRUE if one is found.
//...............................................................
BOOL ChatKeyUserID(LPBYTE lpKeyId)
{
	BOOL			bResult = FALSE;
	LARGE_INTEGER	li;
	DWORD			dwBytesRead;
	DWORD			dwCtb_Byte;
	BYTE			TempCTB;

	SetUpGroup(PUBLIC_KEY,INDEX_KEY,GROUP_TWO);
	li.QuadPart = SearchMyFileBinary(lpIndexFile2,lpKeyId,KEY_ID_SIZE,hIdxHandle2,0,
									 &KeyIdSearch);
	if (li.QuadPart == -1)
	{
		goto ChatKeyEnd;
	}
	// No public key.
	//...............
	if (li.QuadPart == 0)
	{
		goto ChatKeyEnd;
	}
	lpKeyBuffer2 = AllocateMemory(SIZE_KEY_BUFF);
	if (!lpKeyBuffer2)
	{
		goto ChatKeyEnd;
	}
	// We had a match. Go and get the public key.
	//...........................................
	dwIdxOffset2 = li.HighPart;
	dwBytesRead = ReadIndex2();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto ChatKeyEnd;
	}

	dwBytesRead = ReadRecord2();
	if (dwBytesRead == -1 || dwBytesRead == 0)
	{
		goto ChatKeyEnd;
	}
	// We have our public key. Get the user id.
	//.........................................
	lpKeyBufferDup2 = lpKeyBuffer2;

	ZeroMemory(&TempUserId,sizeof(TempUserId));

	while(TRUE)
	{
		__asm
		{
			mov		edi,lpKeyBufferDup2
			mov		al,byte ptr [edi]
			mov		cl,al
			mov		dwCtb_Byte,ecx
			and		al,CTB_MASK
			mov		TempCTB,al
		}
		if (TempCTB != CTB_USER_ID)
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				add		edi,eax
				mov		lpKeyBufferDup2,edi
			}
		}
		else
		{
			GetPcktLength(lpKeyBufferDup2,dwCtb_Byte);

			__asm
			{
				mov		edi,lpKeyBufferDup2
				add		edi,CTB_SIZE
				add		edi,edx
				mov		ecx,eax
				mov		esi,edi
				mov		edi,offset TempUserId
				rep		movsb
			}
			break;
		}
	}
	bResult = TRUE;

	ChatKeyEnd:

	if (lpKeyBuffer2)
	{
		ZeroMemory(lpKeyBuffer2,SIZE_KEY_BUFF);
		DeallocateMemory(lpKeyBuffer2);
		lpKeyBuffer2 = 0;
	}
	return(bResult);
}

// Set the character font for the middle panel.
//.............................................
VOID ClearMsg()
{
	CHARRANGE		cr;

	cr.cpMin = 0;
	cr.cpMax = -1;

	SendMessage(hChat2,EM_EXSETSEL,0,(LPARAM)&cr);
	SendMessage(hChat2,WM_CLEAR,0,0);
}

// Check for an insert smileys into the top panel.
//................................................
VOID CheckandInsertSmileys()
{
	FINDTEXTEX		ft;
	LRESULT			lResult;
	BYTE			MySmiley[16];
	int				iIndex;
	BOOL			bResult;
	DWORD			dwFlags = FR_DOWN;
	LPBYTE			lpSearch;

	lpSearch = (LPBYTE)&szSearchSmiley;

	ft.lpstrText = lpSearch;

	SetFocus(hChat1);

	// Go into a loop and find and replace all the smileys.
	//.....................................................
	while(TRUE)
	{
		SendMessage(hChat1,EM_EXGETSEL,0,(LPARAM)&ft.chrgText);

		if (ft.chrgText.cpMin == ft.chrgText.cpMax)
		{
			ft.chrg.cpMin = lCharPos;
		}
		else if (ft.chrgText.cpMax != -1)
		{
			ft.chrg.cpMin = ft.chrgText.cpMax;
		}
		ft.chrg.cpMax = -1;

		lResult = SendMessage(hChat1,EM_FINDTEXTEX,(WPARAM)dwFlags,(LPARAM)&ft);

		if (lResult == -1)
		{
			// No more matches found.
			//.......................
			break;
		}
		lCharPos = lResult;

		// We found a match, now select all the characters.
		//.................................................
		ft.chrgText.cpMax++;

		SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&ft.chrgText);
		SendMessage(hChat1,EM_GETSELTEXT,0,(LPARAM)&MySmiley);

		iIndex = MySmiley[3];

		if (iIndex <= 63)
		{
			iIndex += 87;
		}
		else if (iIndex <= 124)
		{
			iIndex -= 65;
		}
		else if (iIndex <= 189)
		{
			iIndex -= 10;
		}
		else if (iIndex <= 251)
		{
			iIndex -= 132;
		}
		else if (iIndex == 252)
		{
			iIndex = 180;
		}

		if (iIndex >= 0 && iIndex < MAX_SMILEYS)
		{
			bResult = DisplayMySmiley(iIndex);

			if (!bResult)
			{
				break;
			}
		}
	}
	ft.chrg.cpMin = -1;
	ft.chrg.cpMax = -1;
	SendMessage(hChat1,EM_EXSETSEL,0,(LPARAM)&ft.chrg);
}
